
## ----identity-all.equal--------------------------------------------------
identical(1, 1L)
all.equal(1, 1L)


## ----all.equal-attributes------------------------------------------------
v0 <- c(1, 2); v1 <- c(a=1, b=2)
identical(v0, v1)
all.equal(v0, v1)
all.equal(v0, v1, check.attributes=FALSE)


## ----all.equal-env-------------------------------------------------------
x <- new.env(); y <- new.env()
all.equal(x, y)
x[["a"]] <- 1
all.equal(x, y)


## ----system.time-expression----------------------------------------------
system.time({
    Sys.sleep(1)
    runif(1000)
})


## ----system.time-gets----------------------------------------------------
system.time(x <- runif(10000000))
length(x)
mean(x)


## ----microbenchmark------------------------------------------------------
library(microbenchmark)
f0 <- function(n) runif(n)
f1 <- function(n) replicate(n, runif(1))
times <- microbenchmark(f0(10), f0(100), f0(1000), f0(2000), f1(10), times=100)
times


## ----microbenchmark-times-plot-------------------------------------------
plot(times)


## ------------------------------------------------------------------------
a <- c("A", "C", "G", "T")
n <- 10000000
geno <- paste(sample(a, n, TRUE), sample(a, n, TRUE), sep="_")


## ----, eval=FALSE--------------------------------------------------------
## n <- 3
## for (i in seq_along(x))
##     if (abs(x[i]) > n * sd(x))
##         x[i] <- n * sd(x)


## ----, eval=FALSE--------------------------------------------------------
## set.seed(123)
## x <- runif(10000)


## ----, eval=FALSE--------------------------------------------------------
## x[abs(x) > n * sd(x)] <- n * sd(x)


## ----test-log0, eval=FALSE-----------------------------------------------
## library(RUnit)
## test_log0 <- function() {
##    checkIdentical(-Inf, log(0))
##    checkIdentical(0, log(1))
##    checkIdentical(0, exp(log(0)))
##    checkIdentical(1, exp(log(1)))
##    old_opts <- options(warn=2)
##    on.exit(options(old_opts))
##    checkException(log(-1), silent=TRUE)
##    checkException(log(), silent=TRUE)
## }
## test_log0()


