
## ----xml-load------------------------------------------------------------
library(XML)
xml <- xmlTreeParse("~/xml/msigdb_v4.0.xml", useInternalNodes=TRUE)


## ----xpath-attr----------------------------------------------------------
xml[["/MSIGDB/@NAME"]]


## ----xmlAttrs------------------------------------------------------------
xmlAttrs(xml[["/MSIGDB"]])


## ----nodeset-------------------------------------------------------------
sets <- xml["/MSIGDB/GENESET"]
class(sets)
length(sets)


## ----xml-R---------------------------------------------------------------
head(xmlAttrs(sets[[2]]), 4)


## ----xml-xpath-----------------------------------------------------------
head(xml["//GENESET[2]/@*"], 4)


## ----xml-attr-select-----------------------------------------------------
yy <- xml[["//GENESET[@STANDARD_NAME = 'EXTRINSIC_TO_PLASMA_MEMBRANE']"]]
xmlAttrs(yy)[1:4]


## ----xml-nodeset-iter----------------------------------------------------
organism <- sapply(sets, function(elt) xmlAttrs(elt)["ORGANISM"])


## ----xml-nodeset-xpath---------------------------------------------------
organism <- xpathSApply(xml, "//GENESET/@ORGANISM")
table(organism)


## ----xml-count-----------------------------------------------------------
xml[["count(//GENESET)"]]
xml[["count(//GENESET[@ORGANISM='Homo sapiens'])"]]


