shinyServer(function(input, output, session) {

    output$view <- renderTable({

        org <- input$organism

        keys0 <- input$keys
        keys <- strsplit(gsub(" +", "", keys0), ",")[[1]]
        if (length(keys) == 0)
            keys <- head(keys(map[[org]]), 10)

        cols <- input$columns
        if (length(cols) == 0)
            cols <- head(columns(map[[org]]), 1L)

        select(map[[org]], keys, cols)
    })

    observe({
        updateSelectInput(session, "columns",
                          choices=columns(map[[ input$organism ]]))
    })
    
})
