makeBPMAPenv <- function(bpmapFile, genomebuild="hg12"){
  bpmap <- .Call("ReadBPMAPFileIntoRList", bpmapFile, PACKAGE="affyio")
  n <- length(bpmap$SequenceDescription)
  tmp <- do.call("rbind", lapply(1:n, function(obj) cbind(bpmap$SeqHead.PosInfo[[obj]]$PositionInformation, bpmap$SequenceDescription[[obj]]$Name)))
  names(tmp)[10] <- "chromosome"
  rm(bpmap)
  gc()
  
  dfPM <- tmp[,-c(3, 4, 7)]
  dfMM <- tmp[,-c(1, 2, 7)]
  rm(tmp)
  gc()
  
  dfPM$feature_ID <- dfMM$feature_ID <- 1:nrow(dfPM)
  names(dfMM) <- names(dfPM) <- c("X", "Y", "length", "sequence", "pm_location", "target_strand", "chromosome", "feature_ID")
  dfPM$feature_type <- "PM"
  dfMM$feature_type <- "MM"
  p1 <- substr(dfPM$sequence, 1, 12)
  p2 <- substr(dfPM$sequence, 14, 25)
  base <- substr(dfPM$sequence, 13, 13)
  tmpB <- rep(NA, length(base))
  tmpB[base == "A"] <- "T"
  tmpB[base == "T"] <- "A"
  tmpB[base == "C"] <- "G"
  tmpB[base == "G"] <- "C"
  dfMM$sequence <- paste(p1, tmpB, p2, sep="")
  df <- rbind(dfPM, dfMM)
  rm(dfPM, dfMM)
  gc()
  df$feature_type <- factor(df$feature_type)
  df$target_strand[df$target_strand=="F"] <- "Sense"
  df$target_strand[df$target_strand=="R"] <- "Antisense"
  df$target_strand <- factor(df$target_strand)

  dfClean <- myAggregate(df$pm_location, by=list(X=df$X, Y=df$Y))
  dups <- duplicated(df[, c("X", "Y")])
  df <- df[!dups,]
  df <- df[order(df$Y, df$X), ]
  df$feature_set_name <- dfClean$feature_set_name
  df$ambiguous_feature <-  dfClean$ambiguous_feature
  df$pm_location <- NULL
  rm(dfClean)

  ## assuming that the dimension of a tiling array
  ## is 914 x 914
  sizex <- sizey <- 914
  xy <- expand.grid(X=0:(sizex-1), Y=0:(sizey-1))
  xy$index <- xy$X + xy$Y*sizex
  dfIndex <- df$X + df$Y*sizex
  mm <- match(dfIndex, xy$index)
  toInclude <- xy[!xy$index %in% dfIndex, c("X", "Y")]
  toInclude <- as.data.frame(toInclude)
  toInclude$sequence <- toInclude$length <- NA
  toInclude$feature_type <- toInclude$feature_ID <- toInclude$chromosome <- toInclude$target_strand <- NA
  toInclude$ambiguous_feature <- toInclude$feature_set_name <- NA
  toInclude$feature_set_name <- paste("NotIncluded", 1:nrow(toInclude))
  df <- rbind(df, toInclude)
  df <- df[order(df$Y, df$X), ]
  df$order_index <- 1:nrow(df)
  df <- df[order(df$feature_set_name, df$feature_type, df$target_strand),]
  rownames(df) <- 1:nrow(df)
  df$sequence <- as.character(df$sequence)
  df$position <- NA
  df$position[!df$ambiguous_feature & !is.na(df$ambiguous_feature)] <- as.integer(df$feature_set_name[!df$ambiguous_feature & !is.na(df$ambiguous_feature)])
  df$chromosome <- factor(as.character(df$chromosome), levels=paste("chr",c(as.character(1:22),"X","Y"),sep=""))
  new("platformDesign",
      featureInfo=assign2env(df),
      featureTypeDescription = list(
        feature_type=list(
                       description="This column distinguishes PM and MM features.\nAnything else is left as an NA",
                       levels=list(PM="Perfect Match probe", MM="Mismatch probe")
                       ),
        target_strand = list(
                       description = "Target Strandness",
                       levels = list(Sense = "Sense", Antisense = "Antisense")
                       ),
        location = list(
                       description = "Genomic Location"
                       )),
      manufacturer="Affymetrix",
      type="tiling",
      genomebuild=genomebuild,
      nrow=sizey,
      ncol=sizex)
}

myAggregate <- function(what, by){
  tb <- tapply(what, by, paste, collapse=";")
  dNames <- dimnames(tb)
  tb <- cbind(expand.grid(dNames), matrix(tb, ncol=1))
  tb <- tb[complete.cases(tb),]
  names(tb) <- c(names(by), "feature_set_name")
  tb$X <- as.numeric(levels(tb$X))[tb$X]
  tb$Y <- as.numeric(levels(tb$Y))[tb$Y]
##  tb$length <- as.numeric(levels(tb$length))[tb$length]
##  tb$sequence <- as.character(tb$sequence)
##  tb$target_strand <- as.character(tb$target_strand)
##  tb$feature_ID <- as.numeric(levels(tb$feature_ID))[tb$feature_ID]
  
  tb$feature_set_name <- as.character(tb$feature_set_name)
  tb$ambiguous_feature <- FALSE
  tb$ambiguous_feature[grep(";", tb$feature_set_name)] <- TRUE
  return(tb)
}
