## BEGIN makeNDFenv.R
## NDF Environment
## Author: Benilton Carvalho
## Date: Mar / 2005
## Last Update: Dec / 2005

## Dec 6, 2005 - integrating functionality to deal
##               with multiple well designs.

makeNDFenv <- function(ndffile, xysfile, posfile=NULL, nwells=1, experimental="experimental", expression=TRUE, type="expression", genomebuild=""){
  cat(paste("Reading",ndffile,"\n"))
  if (nwells == 1){
    cat("Assuming a simple design (NOT multiple-wells).\n")
    ndf <- readndf(ndffile, xysfile, posfile)
  }else{
    cat(paste("Assuming a multiple well design with",nwells,"wells.\n"))
    ndf <- readndfplex(ndffile, xysfile, nwells, experimental, expression)
  }
  ndf$ndfdata$sequence <- as.character(ndf$ndfdata$sequence)
  if (type != "tiling") genomebuild=""
  
  new("platformDesign",
      featureInfo=assign2env(ndf$ndfdata),
      featureTypeDescription = list(
        feature_type=list(
                  description="This column distinguishes PM and MM features.\nAnything else is left as an NA",
                  levels=list(
                    PM="Perfect Match probe",
                    MM="Mismatch probe"
                    ))),
      ncol = ndf$ncol,
      nrow = ndf$nrow,
      nwells = nwells,
      lookup = ndf$lookup,
      manufacturer="NimbleGen",
      type=type,
      genomebuild=genomebuild)
}

## END makeNDFenv.R
