## BEGIN makePDpackage.R
##------------------------------------------------------------
## package maker
##------------------------------------------------------------
## Benilton Carvalho

goodname <- function(filein){
  tmp <- tolower(basename(filein))
  tli <- unlist(strsplit(tmp, "\\."))
  n <- length(tli)
  tmp <- tli[1]
  if(n > 2){
    for(i in 2:(n-1)){
      tmp <- paste(tmp, tli[i])
    }
  }
  return(paste("pd",gsub("_|-| +|\\.", "", tmp),sep=""))
}


makePDpackage.old <- function(filename,
                              seqfile=NULL,
                              annotfile=NULL,
                              xysfile=NULL,
                              posfile=NULL,
                              nwells=1,
                              experimental="experimental",
                              expression=TRUE,
                              type="expression",
                              packagename=NULL,
                              cdf.path=getwd(),
                              package.path=getwd(),
                              compress=FALSE,
                              author="The Bioconductor Project",
                              maintainer="The Bioconductor Project <bioconductor@stat.math.ethz.ch>",
                              version=packageDescription("makePlatformDesign", field="Version"),
                              unlink =FALSE,
                              verbose=TRUE,
                              textCDF=FALSE) {

  if(!is.null(seqfile)){
    cat("Assuming Affymetrix Chip\n")
    if(is.null(packagename))
      packagename <- goodname(filename)
    cat(paste("The package will be called",packagename,"\n",sep=" ")) 
    
    if(type=="expression"){
      cat("Expression Array\n")
      designdata <- makeCDFenv(filename, seqfile, cdf.path=cdf.path, compress=compress)
    }
    else if(type=="SNP"){
      cat("SNP Array\n")
      designdata <- makeSNPenv(filename, seqfile, annotfile,textCDF)
    }
    else{ cat(paste(type," Chip not supported\n"))}
  }else if(!is.null(xysfile)){
    cat("Assuming NimbleGen Chip\n")
    if(is.null(packagename))
      packagename <- paste(goodname(filename),sep="")
    cat(paste("The package will be called",packagename,"\n",sep=" ")) 
    designdata <- makeNDFenv(filename, xysfile, posfile, nwells,experimental,expression)
    cat("Environment created.\n")
  }else{
    stop("Please, check the syntax of the command.\n")
  }


  # Add info about the chip
  symbols <- list(PKGNAME    =packagename,
                  VERSION    =version,
                  AUTHOR     =author,
                  TODAY      =date(),
                  DESIGNFILE =filename,
                  MAINTAINER =maintainer)

  writePackage(designdata, packagename, destinationDir=path.expand(package.path),
               originDir=file.path(.path.package("makePlatformDesign"), "Code"),
               symbolValues=symbols, unlink, !verbose)
  
  return(packagename)
}

writePackage <- function(designdata, packagename, destinationDir,
                         originDir, symbolValues, unlink=unlink, quiet=!verbose){
  assign(packagename, designdata)
  res <- createPackage(packagename, destinationDir, originDir, symbolValues, unlink, quiet)
  save(list=packagename, file=file.path(res$pkgdir, "data", paste(packagename,".rda",sep="")), compress=TRUE)
}


makePDpackage <- function(designFile, file1=NULL, file2=NULL,
                          manufacturer=c("affymetrix", "nimblegen"),
                          type=c("expression", "SNP", "tiling"), extra=NULL, genomebuild="hg12"){

  ## file1: sequence file (FASTA/Tab) for affy or xysfile for nimblegen
  ## file2: annotation file for affy or *.pos file for nimblegen
  
  if(is.null(extra))
    extra <- list(packagename=NULL, cdf.path=getwd(), package.path=getwd(),
                  author="The Bioconductor Project",
                  maintainer="The Bioconductor Project <bioconductor@stat.math.ethz.ch>",
                  version=packageDescription("makePlatformDesign", field="Version"),
                  unlink =FALSE, verbose=TRUE)
  
  manufacturer <- match.arg(manufacturer)
  type <- match.arg(type)

  cat(paste(manufacturer, type, "\n"))

  if(is.null(extra$packagename))
    extra$packagename <- goodname(designFile)
  cat(paste("The package will be called", extra$packagename, "\n", sep=" ")) 

  if (type=="expression" & manufacturer=="affymetrix"){
    designdata <- makeCDFenv(designFile, file1, cdf.path=extra$cdf.path)
  }else if(type=="SNP" & manufacturer=="affymetrix"){
    designdata <- makeSNPenv(designFile, file1, file2)
  }else if(type=="tiling" & manufacturer=="affymetrix"){
    designdata <- makeBPMAPenv(designFile, genomebuild=genomebuild)
  }else if((type=="expression"|type=="SNP"|type=="tiling") & manufacturer=="nimblegen"){
    designdata <- makeNDFenv(designFile, file1, file2, type=type, genomebuild=genomebuild)
  }else{
    stop("Check command syntax.\n")
  }

  ## Add info about the chip
  symbols <- list(PKGNAME    = extra$packagename,
                  VERSION    = extra$version,
                  AUTHOR     = extra$author,
                  TODAY      = date(),
                  DESIGNFILE = designFile,
                  MAINTAINER = extra$maintainer)

  writePackage(designdata, extra$packagename, destinationDir=path.expand(extra$package.path),
               originDir=file.path(.path.package("makePlatformDesign"), "Code"),
               symbolValues=symbols, unlink=extra$unlink, quiet=!extra$verbose)
  
  return(extra$packagename)
}

## END makePDpackage.R
