## BEGIN makeSNPenv.R
## SNP Environment
## Author: Benilton Carvalho
## Date: Mar / 2005

makeSNPenv <- function(snpfile, fastafile, annotfile){
  
  cat(paste("Reading",snpfile,"\n"))
  cdfType <- check.cdf.type(snpfile)
  if(cdfType=="text"){
    tmp <- readSNPtxtCDF(snpfile,fastafile, annotfile)
  }else if (cdfType=="xda"){
    tmp <- readSNPCDF(snpfile,fastafile, annotfile)
  }else{
    stop(paste("Format of", snpfile, "is not recognized.\n"))
  }

  tmp$feature_set_name <- as.character(tmp$feature_set_name)
  tmp$sequence <- as.character(tmp$sequence)

  snp <- tmp[[1]]
  dimensions <- tmp[[2]]
  rm(tmp)
  gc()
  envsnp <- new.env()
 
  vars <- names(snp)
  for (i in 1:length(vars)){
    assign(vars[i],snp[,i],envsnp)
  }

  new("platformDesign",
      featureInfo=envsnp,
      featureTypeDescription = list(
        feature_type=list(
                       description="This column distinguishes PM and MM features.\nAnything else is left as an NA",
                       levels=list(
                         PM="Perfect Match probe",
                         MM="Mismatch probe"
                         )),
        allele=list(
          description="calls",
          levels=list(
            A="A",
            T="T",
            G="G",
            C="C"
            )),
        target_strand=list(description="Target Strandness", levels = list( Sense = "Sense", Antisense = "Antisense")),
        snp_location=list(description="location of the SNP"),
        ),
      manufacturer="Affymetrix",
      type="SNP",
      nrow=dimensions$nrow,
      ncol=dimensions$ncol)
}
## END makeSNPenv.R
