## BEGIN readndf.R
## Reading NimbleGen Data
## Author: Benilton Carvalho
## Date: Mar / 2005
## 
## December 9, 2005:
## OLD		MEANING					NEW
## feature_type_1: feature_type (PM/MM)			feature_type
## feature_type_2: calls (for SNP chips)			allele
## feature_type_3: sense/antisense (for SNP chips)		target_strand
## feature_type_4: SNP (for SNP chips)			snp_location


readndf <- function(ndffile, xysfile, posfile=NULL){
  
  types <- list(X = numeric(0), Y=numeric(0),SIGNAL=numeric(0),COUNT=numeric(0))
  header <-  scan(xysfile,sep = "\t",nlines = 1,skip = 1,quiet = TRUE,what = character(0))
  whatToRead <- types[match(header,names(types))]
  xys <- scan(xysfile,sep = "\t", skip =2, quiet = T, what = whatToRead)
  xys <- data.frame(X = as.integer(xys$X), Y = as.integer(xys$Y))

  ndfdata <- readrawndf(ndffile)
  sizex <- max(ndfdata$X)
  sizey <- max(ndfdata$Y)

  key <- max(ndfdata$Y)
  xysindex <- xys$X*key + xys$Y
  ndfindex <- ndfdata$X*key + ndfdata$Y
  linesinndf <- match(xysindex,ndfindex)

  ndfdata <- ndfdata[linesinndf,]

  ## right order of variables in the environment
  ndfdata <- data.frame(X = ndfdata$X,
                        Y = ndfdata$Y,
                        feature_set_name = ndfdata$SEQ_ID,
                        sequence = as.character(ndfdata$PROBE_SEQUENCE),
                        feature_ID = ndfdata$MATCH_INDEX,
                        feature_type = ndfdata$PROBETYPE,
                        position = ndfdata$POSITION,
                        feature_position_ID = ndfdata$PROBE_ID)
  ndfdata$order_index <- ndfdata$X + (ndfdata$Y - 1)*sizex

  if( !is.null(posfile)){
    cat("Correcting probe positions... ")
    posfile <- read.delim(posfile)
    matching <- match(ndfdata$feature_position_ID, posfile$PROBE_ID)
    ndfdata$position <- posfile[matching, "POSITION"]
    ndfdata$feature_type[is.na(ndfdata$position)] <- NA
    ndfdata$chromosome <- posfile[matching, "CHROMOSOME"]
    cat("Done.\n")
  }

  ndfdata <- ndfdata[order(ndfdata$feature_set_name, ndfdata$feature_type, ndfdata$position),]
  rownames(ndfdata) <- 1:nrow(ndfdata)

  out <- list("ndfdata" = ndfdata, "ncol" = sizex, "nrow" = sizey, "lookup" = data.frame(X=ndfdata$X,Y=ndfdata$Y,index=ndfdata$order_index))
  return(out)
}

## END readndf.R
