## BEGIN readndfplex.R
## Reading NimbleGen NDF File for Multiplex Designs
## Author: Benilton Carvalho
## Date: Dez / 2005
## 
## 
## December 9, 2005: Modification of some variable names:
##   OLD		MEANING					NEW
## feature_type_1: feature_type (PM/MM)			feature_type
## feature_type_2: calls (for SNP chips)			allele
## feature_type_3: sense/antisense (for SNP chips)		target_strand
## feature_type_4: SNP (for SNP chips)			snp_location

readndfplex <- function(ndffile, xysfile=NULL, nwells, experimental="experimental", expression=TRUE){

  ## read NDF file
  ndf <- read.delim(ndffile, as.is=TRUE)

  sizex <- max(ndf$X)
  sizey <- max(ndf$Y)

  ## Keep only experimental probes in memory
  ndf$PROBE_CLASS <- factor(ndf$PROBE_CLASS)

  ndf <- subset(ndf,PROBE_CLASS == "experimental" | PROBE_CLASS == "")

  
  ##  ndf <- subset(ndf, PROBE_CLASS == experimental)
  if (expression){
    ## right order of variables in the environment
    ndfdata <- data.frame(X = ndf$X,
                          Y = ndf$Y,
                          feature_set_name = ndf$SEQ_ID,
                          sequence = as.character(ndf$PROBE_SEQUENCE),
                          feature_type = NA,
                          position = ndf$POSITION,
                          container = ndf$CONTAINER)
    
    ndfdata$feature_type[ndf$MISMATCH == 0] <- "PM"
    ndfdata$feature_type[ndf$MISMATCH > 0] <- "MM"
    ndfdata$feature_type <- factor(ndfdata$feature_type)
    
    ndfdata <- ndfdata[order(ndfdata$feature_set_name,
                             ndfdata$feature_type,
                             ndfdata$position,
                             ndfdata$container),]
    
    colids <- match(c("X","Y","container"),names(ndfdata))
    
  }else{

    ## We should look at the DESIGN_NOTE field
    ## to know what is PM/MM
    ndf$PROBETYPE <- "PM"
    ndf$ALLELE <- NA
    ndf$STRAND <- NA
    iA <- which(ndf$MISMATCH == 10000 | ndf$MISMATCH == 10004)
    iC <- which(ndf$MISMATCH == 10001 | ndf$MISMATCH == 10005)
    iG <- which(ndf$MISMATCH == 10002 | ndf$MISMATCH == 10006)
    iT <- which(ndf$MISMATCH == 10003 | ndf$MISMATCH == 10007)
    iForward <- which(ndf$MISMATCH <= 10003 & ndf$MISMATCH >= 10000)
    iReverse <- which(ndf$MISMATCH >= 10004 & ndf$MISMATCH <= 10007)
    ndf$ALLELE[iA] <- "A"
    ndf$ALLELE[iC] <- "C"
    ndf$ALLELE[iG] <- "G"
    ndf$ALLELE[iT] <- "T"
    ndf$STRAND[iForward] <- "Forward"
    ndf$STRAND[iReverse] <- "Reverse"

    ndfdata <- data.frame(X = ndf$COL_NUM,
                          Y = ndf$ROW_NUM,
                          X_CHIP=ndf$X,
                          Y_CHIP=ndf$Y,
                          feature_set_name = ndf$SEQ_ID,
                          sequence = as.character(ndf$PROBE_SEQUENCE),
                          feature_ID = ndf$MATCH_INDEX,
                          feature_type = ndf$PROBETYPE,
                          allele = as.factor(ndf$ALLELE),
                          target_strand = as.factor(ndf$STRAND),
                          position = ndf$POSITION,
                          container = ndf$CONTAINER)
  
    ndfdata <- ndfdata[order(ndfdata$feature_set_name,
                             ndfdata$feature_type,
                             ndfdata$allele,
                             ndfdata$target_strand,
                             ndfdata$position,
                             ndfdata$container),]
    colids <- match(c("X_CHIP","Y_CHIP","container"),names(ndfdata))
  }
  rownames(ndfdata) <- 1:(nrow(ndfdata))

  smallndf <- unique(ndfdata[,-colids])
  smallndf$feature_set_name <- as.character(smallndf$feature_set_name)
  smallndf$sequence <- as.character(smallndf$sequence)
  
##  rows <- as.numeric(c(rownames(smallndf), (nrow(ndfdata)+1)))

  xycontainer <- ndfdata[,colids]
  names(xycontainer) <- c("X", "Y", "container")
  
##   browser()
##   xycontainer$line <- rep(1:(length(rows)-1), each = nwells)
##   xycontainer$column <- as.integer(xycontainer$container)
  xycontainer$index <- xycontainer$X + (xycontainer$Y-1)*sizex
  out <- list("ndfdata" = smallndf, "ncol" = sizex, "nrow" = sizey, "lookup" = xycontainer)

  return(out)
}

## END readndfplex.R
