\name{makePDpackage}
\alias{makePDpackage}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Platform Design Package Maker}
\description{
  This function creates the Platform Design package for Affymetrix and
  NimbleGen chips.
}
\usage{
makePDpackage(designFile, file1=NULL, file2=NULL,
              manufacturer=c("affymetrix", "nimblegen"),
              type=c("expression", "SNP", "tiling"), extra=NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{designFile}{a string with the name of the CDF/NDF file}
  \item{file1}{the FASTA/tab sequence file or the XYS file}
  \item{file2}{the annotation or *.POS file}
  \item{manufacturer}{a choice between "affymetrix" or "nimblegen"}
  \item{type}{a choice between "expression" or "SNP"}
  \item{extra}{a list with several options for customization}
}

\details{
  \code{designFile} is either a CDF or an NDF file, depending on the
  platform being used.

  \code{file1} is the FASTA sequence file if using an Affymetrix SNP
  Chip. It will be the tab-delimited sequence file if using an
  Affymetrix Expression Chip. If using a NimbleGen Chip, then it is an
  XYS file.

  \code{file2} is the annotation file for Affymetrix Chips or the *.POS
  file for NimbleGen Chips. Required for SNP Chips, optional otherwise.

  \code{extra} is a list containing *all* the following elements:
  "packagename" (desired package name), "cdf.path" (path to the CDF),
  "package.path" (path where the package is to be saved), "author"
  (author of the package), "maintainer" (maintainer of the package),
  "version" (version of the package), "unlink" (boolean, deletes the
  package.path dir if it already exists), "verbose" (boolean).
}

\value{
  Either an \code{affysnpBatch} or an \code{affyexprsBatch} object,
  depending on the type of the array (SNP or expression).
}

\author{Benilton Carvalho \email{bcarvalh@jhsph.edu}, Rafael A. Irizarry, Ben Bolstad.}

\seealso{ \code{\link{writePackage}} }
\examples{
## NOT RUN
##
## -- Affymetrix Expression Chip --
## makePDpackage("CDF", "TAB-sequence-file", manufacturer="affymetrix",
##                type="expression")
##
## -- Affymetrix SNP Chip --
## makePDpackage("CDF", "FASTA", "ANNOT", manufacturer="affymetrix",
##                type="SNP")
##
## -- NimbleGen Expression Chip --
## makePDpackage("NDF", "XYS", "POS", manufacturer="nimblegen",
##                type="expression")

}
\keyword{manip}% at least one, from doc/KEYWORDS
