## First line, from the Bioconductor download page;

setwd( "C:/Documents and Settings/kenrice/Desktop/BiocWorkshop" )
source("http://bioconductor.org/biocLite.R")

##
## Hexbin
##

biocLite("hexbin") ### ONLY NEED TO DO ONCE!
library(hexbin)
library(Biobase)
openVignette("hexbin")

#the vignette example
x <- rnorm(20000)
y <- rnorm(20000)
hbin <- hexbin(x, y, xbins = 40)
plot(hbin, main="Made-up data, x and y are N(0,1)")

#the niehs example
niehs <- read.csv("http://faculty.washington.edu/kenrice/sisg/niehs.csv")

#which columns are trt, ctrl?
trt <- grep("T", names(niehs))
ctrl <- grep("C", names(niehs))

means <- data.frame(
   trt.mean  = rowMeans(niehs[, trt], na.rm=T), 
   ctrl.mean = rowMeans(niehs[,ctrl], na.rm=T)
)

hbin2 <- with(means, hexbin(y=trt.mean, x=ctrl.mean) )
plot(hbin2, main="NIEHS data")

plot(trt.mean~ctrl.mean, data=means)

##
## snpMatrix example
##
source("http://bioconductor.org/biocLite.R")

biocLite("snpMatrix") ### ONLY NEED TO DO ONCE!
library("snpMatrix")

load("AMDchrom1.Rdata")

snpsum <- summary(amd1) # tried to do 9122 summaries...

sample.qc <- row.summary(amd1)
plot(sample.qc) # plot of call rate vs heterozygosity

cc.status <- rep(1:0, times=c(96,50) )

my.tests <- single.snp.tests(cc.status, snp.data=amd1)
summary(my.tests)

names(my.tests)
qq.chisq(chi.squared(my.tests, df=1), df=1)

##
## siggenes
##

source("http://bioconductor.org/biocLite.R")
biocLite("siggenes") ### ONLY NEED TO DO ONCE!

library(siggenes)
library(multtest)

vsn<-read.csv("http://faculty.washington.edu/kenrice/sisg/data.vsn.csv")
vsn<-vsn[,-1]
ann<-read.table("http://faculty.washington.edu/kenrice/sisg/annt.txt",header=TRUE)

sam.cl<-as.character(ann$Donor)
sam.cl[!sam.cl=="Hsa"]<-"other primate"
sam.cl

library(siggenes)
vsn.out<-sam(vsn, sam.cl, B=1000, rand=42)

summary(vsn.out)

plot(vsn.out)

plot(vsn.out, 3)


