extdata <- system.file("extdata", package="AdvancedR")
fname <- file.path(extdata, "gwas_2.rda")
fname0 <- tempfile()
local({
    load(fname)
    write.csv(gwas, fname0)
})

f0 <- function(fileName) {
    read.csv(fileName, row.names=1)
}

f1 <- function(fileName) {
    colClasses <- c("character", "factor", "factor", "integer",
                    rep("NULL", 10000))
    read.csv(fileName, row.names=1, colClasses=colClasses)
}

f2 <- function(fileName) {
    what <- c(list(id=character(),
                   CaseControl=character(),
                   Sex=character(),
                   Age=integer()),
              rep(list(NULL), 10000))
    input <- scan(fileName, what=what, sep=",", skip=1, quiet=TRUE)
    as.data.frame(input[2:4], row.names=input[[1]])
}

shuffle0 <- function(genotypes, seed=123L) {
    set.seed(seed)
    samp <- sample(genotypes)
    g <- unlist(samp)
    matrix(g, ncol=ncol(genotypes))
}

shuffle1 <- function(genotypes, seed=123L) {
    set.seed(seed)
    samp <- sample(genotypes)
    g <- unlist(samp, use.names=FALSE)
    matrix(g, ncol=ncol(genotypes))
}

shuffle2 <- function(genotypes, seed=123L) {
    set.seed(seed)
    as.matrix(sample(genotypes))
}

snp0 <- function(i, gwas) {
    snp <- gwas[,-c(1:3)]
    glm(CaseControl ~ Age + Sex + snp[,i], family=binomial, data=gwas)
}
