
library(edgeR)

load("abc.Rdata")

f <- calcNormFactors(abc)
d <- DGEList(counts=abc, group=gsub("_[12]","",colnames(abc)), lib.size=colSums(abc)*f )

d <- estimateCommonDisp(d)

## create a copy of the 
dhack <- d
dhack$samples$group <- as.factor(rep(1,ncol(abc)))
dhack <- estimateCommonDisp(dhack)

dhack$common.dispersion

d$common.dispersion <- dhack$common.dispersion

de <- exactTest(d, pair=c("Normal_MBD2IP","Cancer_MBD2IP"))
topTags(de)


##> abc["chr7.27169940",]  # HOXA cluster
##Cancer_MBD2IP_1 Cancer_MBD2IP_2 Normal_MBD2IP_1 Normal_MBD2IP_2 
##            114             124               0               0 

