library(graph)
library(Rgraphviz)
packages <- c("Rsamtools", "ShortRead",
              "GenomicRanges", "IRanges", "Biostrings",
              "BSgenome", "rtracklayer", "GenomicFeatures")
edgeList <- vector("list", length = length(packages))
names(edgeList) <- packages
edgeList[["IRanges"]] <- list(cex=10)
edgeList[["GenomicRanges"]] <- list(edges = match("IRanges", packages))
edgeList[["Biostrings"]] <- list(edges = match("IRanges", packages))
edgeList[["Rsamtools"]] <- list(edges = match(c("GenomicRanges", "Biostrings"), packages))
edgeList[["ShortRead"]] <- list(edges = match("Rsamtools", packages))
edgeList[["BSgenome"]] <- list(edges = match(c("GenomicRanges", "Biostrings"), packages))
edgeList[["rtracklayer"]] <- list(edges = match("BSgenome", packages))
edgeList[["GenomicFeatures"]] <- list(edges = match("rtracklayer", packages))
pkgSuite <- new("graphNEL", nodes=packages, edgeL=edgeList, edgemode="directed")
renderGraph(layoutGraph(pkgSuite, layoutType="dot",
                        attrs=list(node=list(fontsize=36, shape="plaintext"))))
