library(EatonEtAlChIPseq)
fl <- system.file("extdata", 
  "GSM424494_wt_G2_orc_chip_rep1_S288C_14.mapview.txt.gz",
  package="EatonEtAlChIPseq") 
aln <- readAligned(fl, type = "MAQMapview")
alnp <- aln[strand(aln) == "+"]            

islands0 <- slice(coverage(alnp), 1)
(islands <- islands0[["S288C_14"]])
idx <- head(order(viewMaxs(islands),
                  decreasing=TRUE))
bigIslands <- islands[idx]
rle <- bigIslands[[1]]
plot(start(bigIslands)[[1]] + cumsum(runLength(rle)), 
     runValue(rle), type="l")

library(org.Sc.sgd.db)
start <- toTable(org.Sc.sgdCHRLOC)
end <- toTable(org.Sc.sgdCHRLOCEND)
tbl <- merge(start, end)
tbl <- with(tbl,
            tbl[Chromosome=='14' & start > 0,])
head(tbl)

library(Biobase)
pts <- matchpt(end(bigIslands), tbl$start)
tbl[pts$index,]
ids <- tbl[pts$index, "systematic_name"]
toTable(org.Sc.sgdDESCRIPTION[ids])
