renewEatonEtAl <-
    function(aln)
{
    ## re-code chromosome
    chr <- chromosome(aln)
    levels(chr) <- "chrXIV"

    ## reverse quality scores, and reverse-complement sequences
    idx <- strand(aln) == "-"

    qual <- quality(quality(aln))
    qual[idx] <- reverse(qual[idx])

    seq <- sread(aln)
    seq[idx] <- reverseComplement(seq[idx])

    ## ShortRead updates objects using 'renew'
    renew(aln, sread=seq, quality=FastqQuality(qual),
          chromosome=chr)
}
