library(GenomicFeatures)
fl <- system.file("extdata",
                  "CaffeineTxdb.sqlite", 
                  package="Rsamtools")
bamRanges <- transcripts(loadFeatures(fl))

library(Rsamtools)
fl <- system.file("extdata",
                  "slxMaq09_urls.txt", 
                  package="Rsamtools")
slxMaq09 <- readLines(fl)

bamExperiment <- 
    list(description="Caffeine metabolism views on 1000 genomes samples",
         created=date())
bv <- BamViews(slxMaq09, bamRanges=bamRanges, 
               bamExperiment=bamExperiment)

bv
bamExperiment(bv)

## olaps <- readBamGappedAlignments(bv)
load(system.file("extdata", "olaps.Rda",
                 package="Rsamtools"))

olaps
head(olaps[[1]])
