load_pheno.orig <- function()
{
    data_file <- system.file("extdata", "ALL_pdata.txt",
                             package = "ALLpheno")
    df <- read.table(data_file, comment.char = "%")
    bcell <- grepl("^B", as.character(df$BT))
    types <- c("NEG", "BCR/ABL")
    moltyp <- as.character(df$mol.biol) %in% types
    df[bcell & moltyp, ]
}

load_pheno <- function()
{
    data_file <- system.file("extdata", "ALL_pdata.txt",
                             package = "ALLpheno")
    df <- read.table(data_file, comment.char = "%")
    subset_ALL(df, cell.type = "B", mol.types = c("BCR/ABL", "NEG"))
}

subset_ALL <- function(x, cell.type = c("B", "T"),
                       mol.types = c("BCR/ABL", "NEG"))
{
    cell.type <- match.arg(cell.type)
    bcell <- grepl(paste("^", cell.type, sep=""),
                   as.character(x[["BT"]]))
    moltype <- as.character(x[["mol.biol"]]) %in% mol.types
    if (!any(moltype))
        warning("No patients matched mol.types of:",
                paste(mol.types, collapse=", "))
    s <- x[bcell & moltype, ]
    ## recode factors to drop levels
    ## that are no longer present in the data
    s[["BT"]] <- factor(s[["BT"]])
    s[["mol.biol"]] <- factor(s[["mol.biol"]])
    s
}
