\name{subset_ALL}
\alias{subset_ALL}
\title{
Subset ALL patient data by cell type and mutation
}
\description{
A resuable subsetting function to select patent data for a particular
cell type of ALL with a specified list of mutation types.
}
\usage{
subset_ALL(x, cell.type = c("B", "T"), mol.types = c("BCR/ABL", "NEG"))
}
\arguments{
  \item{x}{
    An object that behaves like a data.frame containing ALL patient
    data.  This function uses columns "BT" and "mol.biol".
}
  \item{cell.type}{
    The type of ALL, one of "B" or "T", for B-cell or T-cell ALL,
    respectively.
}
  \item{mol.types}{
    Mutation type.
}
}
\details{
  The "BT" and "mol.biol" factors are recoded in the returned subset.
}
\value{
An object with the same class as x, but only including patients that
match the specified criteria.
}
\author{
S. Falcon
}
