###################################################
### chunk: ReadAffy1 eval=FALSE
###################################################

###################################################
### chunk: ReadAffy2 eval=FALSE
###################################################

###################################################
### chunk: CLL
###################################################
library("CLL")
data("CLLbatch")
CLLbatch 


###################################################
### chunk: sns
###################################################
sampleNames(CLLbatch)


###################################################
### chunk: disease
###################################################
data("disease")
head(disease)


###################################################
### chunk: rownamesdisease
###################################################
rownames(disease) = disease$SampleID


###################################################
### chunk: removeCELsuffix
###################################################
sampleNames(CLLbatch) = sub("\\.CEL$", "", 
    sampleNames(CLLbatch))


###################################################
### chunk: mt
###################################################
mt = match(rownames(disease), sampleNames(CLLbatch))


###################################################
### chunk: ADF
###################################################
vmd = data.frame(labelDescription = c("Sample ID",  
    "Disease status: progressive or stable disease"))


###################################################
### chunk: samplesCLLbatch
###################################################
phenoData(CLLbatch) = new("AnnotatedDataFrame", 
    data = disease[mt, ], varMetadata = vmd)


###################################################
### chunk: dropmissing
###################################################
CLLbatch = CLLbatch[, !is.na(CLLbatch$Disease)]


###################################################
### chunk: qccalc
###################################################
library("affyQCReport")
saqc = qc(CLLbatch)


###################################################
### chunk: qcplot
###################################################
plot(saqc)


###################################################
### chunk: dist2
###################################################
dd = dist2(log2(exprs(CLLbatch)))


###################################################
### chunk: setupdistplot
###################################################
diag(dd) = 0
dd.row <- as.dendrogram(hclust(as.dist(dd)))
row.ord <- order.dendrogram(dd.row)
library("latticeExtra")
legend = list(top=list(fun=dendrogramGrob, 
    args=list(x=dd.row, side="top")))
lp = levelplot(dd[row.ord, row.ord], 
    scales=list(x=list(rot=90)), xlab="", 
    ylab="", legend=legend)



###################################################
### chunk: affyPLM
###################################################
library("affyPLM")
dataPLM = fitPLM(CLLbatch)


###################################################
### chunk: NUSE
###################################################
boxplot(dataPLM, main="NUSE", ylim = c(0.95, 1.22),
    outline = FALSE, col="lightblue", las=3, 
    whisklty=0, staplelty=0)


###################################################
### chunk: RLE
###################################################
Mbox(dataPLM, main="RLE", ylim = c(-0.4, 0.4), 
    outline = FALSE, col="mistyrose", las=3, 
    whisklty=0, staplelty=0)


###################################################
### chunk: dropBadarrays
###################################################
badArray = match("CLL1", sampleNames(CLLbatch))
CLLB = CLLbatch[, -badArray]


###################################################
### chunk: repRLENUSE
###################################################
dataPLMx = fitPLM(CLLB)
boxplot(dataPLM, main="NUSE", ylim = c(0.95, 1.3),
     outline = FALSE, col="lightblue", las=3,
     whisklty=0, staplelty=0)
Mbox(dataPLM, main="RLE", ylim = c(-0.4, 0.4), 
    outline = FALSE, col="mistyrose", las=3, 
    whisklty=0, staplelty=0)


###################################################
### chunk: rma
###################################################
CLLrma = rma(CLLB)


###################################################
### chunk: exprsDemo
###################################################
e = exprs(CLLrma)
dim(e)
dim(CLLrma)


###################################################
### chunk: howmanyprobesets
###################################################
dim(e)[1]
nrow(e)
dim(exprs(CLLrma))[1]
nrow(CLLrma)
length(featureNames(CLLrma))


###################################################
### chunk: pData1
###################################################
pData(CLLrma)[1:3,]


###################################################
### chunk: pData2
###################################################
table(CLLrma$Disease)
