setGeneric("countFlags",
           function(file, index=file, ..., param=ScanBamParam())
           standardGeneric("countFlags"),
           signature="file")

setMethod(countFlags, "BamFile",
          function(file, index=file, ..., param=ScanBamParam())
{
    key <- c(isPaired=1L, isProperPair=2L, isUnmappedQuery=4L,
             hasUnmappedMate=8L, isMinusStrand=16L,
             isMateMinusStrand=32L, isFirstMateRead=64L,
             isSecondMateRead=128L, isPrimaryRead=256L,
             isValidVendorRead=512L, isDuplicate=1024L)

    bamWhat(param) <- "flag"
    flags <- scanBam(file, ..., param=param)
    df <- as.data.frame(t(sapply(flags, function(elt, key) {
        flag <- table(elt[[1]])
        sapply(key, function(k, f)
               sum(f[bitAnd(names(f), k) != 0]), flag)
    }, key)))
    rng <- rownames(df)
    rownames(df) <- NULL
    cbind(File=basename(path(file)), Range=rng, df)
})

setMethod(countFlags, "BamFileList",
    function(file, index=file, ..., param=ScanBamParam())
{
    do.call(rbind, lapply(file, countFlags, ..., param=param))
})

setMethod(countFlags, "character",
    function(file, index=file, ..., param=ScanBamParam())
{
    bam <- Map(BamFile, file, index)
    countFlags(open(bam), ..., param=param)
})
