setGeneric("insertSize",
           function(file, index=file, ..., param=ScanBamParam())
           standardGeneric("insertSize"),
           signature="file")

setMethod(insertSize, "BamFile",
    function(file, index=file, ..., param=ScanBamParam())
{
    bamFlag(param) <- scanBamFlag(isProperPair=TRUE, isFirstMateRead=TRUE)
    bamWhat(param) <- c("pos", "mpos")
    ans <- scanBam(file, ..., param=param)
    lapply(ans, function(elt) with(elt, abs(pos - mpos)))
})

setMethod(insertSize, "BamFileList",
    function(file, index=file, ..., param=ScanBamParam())
{
    res <- lapply(file, insertSize, ..., param=param)
    names(res) <- basename(sapply(file, path))
    res
})
