### R code from vignette source 'DataExploration.Rnw'

###################################################
### code chunk number 1: setup
###################################################
stopifnot(getRversion() >= "2.13.0" && getRversion() < "2.14.0")
library(useR2011)


###################################################
### code chunk number 2: fastq-format
###################################################
fls <- list.files(file.path(bigdata(), "fastq"), full=TRUE)
cat(noquote(readLines(fls[[1]], 4)), sep="\n")


###################################################
### code chunk number 3: ascii
###################################################
cat(rawToChar(as.raw(32+1:47)),
    rawToChar(as.raw(32+48:94)), sep="\n")


###################################################
### code chunk number 4: readFastq
###################################################
fastqDir <- file.path(bigdata(), "fastq")
fastqFiles <- list.files(fastqDir, full=TRUE)
fq <- readFastq(fastqFiles[1], withIds=TRUE)
fq


###################################################
### code chunk number 5: sread
###################################################
head(sread(fq), 3)
head(quality(fq), 3)
head(id(fq), 3)


###################################################
### code chunk number 6: getClasse
###################################################
getClass("ShortReadQ")


###################################################
### code chunk number 7: showMethods-ShortRead (eval = FALSE)
###################################################
## showMethods(class="ShortRead", where=getNamespace("ShortRead"))


###################################################
### code chunk number 8: width-ShortRead
###################################################
table(width(fq))


###################################################
### code chunk number 9: width-ShortReadQ
###################################################
abc <- alphabetByCycle(sread(fq))
abc[1:4, 1:8]


###################################################
### code chunk number 10: FastqSampler
###################################################
sampler <- FastqSampler(fastqFiles[1], 1000000)
yield(sampler) # sample of 1000000 reads


###################################################
### code chunk number 11: qa (eval = FALSE)
###################################################
## qas0 <- Map(function(fl, nm) {
##     fq <- FastqSampler(fl)
##     qa(yield(fq), nm)
## }, fastqFiles, 
##    sub("_subset.fastq", "", basename(fastqFiles)))
## qas <- do.call(rbind, qas0)
## rpt <- report(qas, dest=tempfile())
## browseURL(rpt)


###################################################
### code chunk number 12: report (eval = FALSE)
###################################################
## rpt <- system.file("GSM461176_81_qa_report", package="useR2011")
## browseURL(rpt)


###################################################
### code chunk number 13: fastq-discovery
###################################################
list.files(bigdata())
fls <- list.files(file.path(bigdata(), "fastq"), full=TRUE)


###################################################
### code chunk number 14: fastq-input
###################################################
fq <- readFastq(fls[1])


###################################################
### code chunk number 15: gcC
###################################################
alf0 <- alphabetFrequency(sread(fq), as.prob=TRUE, collapse=TRUE)
sum(alf0[c("G", "C")])


###################################################
### code chunk number 16: gc-reads
###################################################
gc <- gcFunction(sread(fq))
hist(gc)


###################################################
### code chunk number 17: abc
###################################################
abc <- alphabetByCycle(sread(fq))
matplot(t(abc[c("A", "C", "G", "T"),]), type="l")


###################################################
### code chunk number 18: abc-mclapply (eval = FALSE)
###################################################
## library(multicore)
## gc0 <- mclapply(fls, function(fl) {
##   fq <- readFastq(fl)
##   gc <- gcFunction(sread(fq))
##   table(cut(gc, seq(0, 1, .05)))
## })
## ## simplify list of length 2 to 2-D array
## gc <- simplify2array(gc0)
## matplot(gc, type="s")


###################################################
### code chunk number 19: quality
###################################################
head(quality(fq))
qual <- as(quality(fq), "matrix")
dim(qual)
plot(colMeans(qual), type="b")


###################################################
### code chunk number 20: SAM
###################################################
fl <- system.file("extdata", "ex1.sam", package="Rsamtools")
strsplit(readLines(fl, 1), "\t")[[1]]


###################################################
### code chunk number 21: readGappedAlignments
###################################################
alnFile <- system.file("extdata", "ex1.bam", package="Rsamtools")
aln <- readGappedAlignments(alnFile)
head(aln, 3)


###################################################
### code chunk number 22: GappedAlignments-accessors
###################################################
table(strand(aln))
table(width(aln))
head(sort(table(cigar(aln)), decreasing=TRUE))


###################################################
### code chunk number 23: bam-ex-fls
###################################################
fls <- list.files(file.path(bigdata(), "bam"), "bam$", full=TRUE)
names(fls) <- sub("_.*", "", basename(fls))


###################################################
### code chunk number 24: bam-ex-input
###################################################
## input
aln <- readGappedAlignments(fls[1])
xtabs(~rname + strand, as.data.frame(aln))


###################################################
### code chunk number 25: bam-ex-roi
###################################################
data("ex")           # from an earlier exercise


###################################################
### code chunk number 26: bam-ex-strand
###################################################
strand(aln) <- "*"   # protocol not strand-aware


###################################################
### code chunk number 27: bam-ex-hits
###################################################
hits <- countOverlaps(aln, ex)
table(hits)


###################################################
### code chunk number 28: bam-ex-cnt
###################################################
cnt <- countOverlaps(ex, aln[hits==1])


###################################################
### code chunk number 29: bam-count-fun
###################################################
counter <- 
    function(filePath, range)
{
    aln <- readGappedAlignments(filePath)
    strand(aln) <- "*"
    hits <- countOverlaps(aln, range)
    cnt <- countOverlaps(range, aln[hits==1])
    names(cnt) <- names(range)
    cnt
}


###################################################
### code chunk number 30: bam-count-all
###################################################
counts <- sapply(fls, counter, ex)


###################################################
### code chunk number 31: bam-count-mclapply (eval = FALSE)
###################################################
## if (require(multicore))
##     simplify2array(mclapply(fls, counter, ex))


###################################################
### code chunk number 32: gc-read
###################################################
param <- ScanBamParam(what="seq")
seqs <- scanBam(fls[[1]], param=param)
readGC <- gcFunction(seqs[[1]][["seq"]])
hist(readGC)


