### R code from vignette source 'RBioc.Rnw'

###################################################
### code chunk number 1: setup
###################################################
stopifnot(getRversion() >= "2.13.0" && getRversion() < "2.14.0")
library(useR2011)


###################################################
### code chunk number 2: prompt
###################################################
## assign values 5, 4, 3, 2, 1 to variable 'x'
x <- c(5, 4, 3, 2, 1)
x


###################################################
### code chunk number 3: colon
###################################################
x[2:4]


###################################################
### code chunk number 4: log
###################################################
log(x)


###################################################
### code chunk number 5: types
###################################################
c(1.1, 1.2, 1.3)         # numeric
c(FALSE, TRUE, FALSE)    # logical
c("foo", "bar", "baz")   # character, single or double quote ok
as.character(x)          # convert 'x' to character
typeof(x)                # the number 5 is numeric, not integer
typeof(2L)               # append 'L' to force integer
typeof(2:4)              # ':' produces a sequence of integers


###################################################
### code chunk number 6: factor
###################################################
sex <- factor(c("Male", "Female", NA), levels=c("Female", "Male"))
sex


###################################################
### code chunk number 7: lists
###################################################
lst <- list(a=1:3, b=c("foo", "bar"), c=sex)
lst


###################################################
### code chunk number 8: list-subset
###################################################
lst[c(3, 1)]             # another list
lst[["a"]]               # the element itself, by name


###################################################
### code chunk number 9: data.frame
###################################################
df <- data.frame(age=c(27L, 32L, 19L),
                 sex=factor(c("Male", "Female", "Male")))
df
df[c(1, 3),]
df[df$age > 20,]


###################################################
### code chunk number 10: matrix
###################################################
m <- matrix(1:12, nrow=3)
m
m[c(1, 3), c(2, 4)]
m[, 3]
m[, 3, drop=FALSE]


###################################################
### code chunk number 11: lm
###################################################
x <- rnorm(1000, sd=1)
y <- x + rnorm(1000, sd=.5)
fit <- lm(y ~ x)       # formula describes linear regression 
fit                    # an 'S3' object
anova(fit)
sqrt(var(resid(fit)))  # residuals accessor and subsequent transforms
class(fit)


###################################################
### code chunk number 12: function-args
###################################################
y <- 5:1
log(y)
args(log)        # arguments 'x' and 'base'; see ?log
log(y, base=2)   # 'base' is optional, with default value
try(log())       # 'x' required; 'try' continues even on error
args(data.frame) # ... represents variable number of arguments


###################################################
### code chunk number 13: named-args
###################################################
log(base=2, y)   # match argument 'base' by name, 'x' by position


###################################################
### code chunk number 14: S3-method-args
###################################################
args(anova)
args(anova.glm)


###################################################
### code chunk number 15: lattice (eval = FALSE)
###################################################
## library(lattice)
## dotplot(variety ~ yield | site, data = barley, groups = year,
##         key = simpleKey(levels(barley$year), space = "right"),
##         xlab = "Barley Yield (bushels/acre) ",
##         aspect=0.5, layout = c(2,3), ylab=NULL)


###################################################
### code chunk number 16: lattice-doit
###################################################
pdf("lattice-example.pdf")
library(lattice)
dotplot(variety ~ yield | site, data = barley, groups = year,
        key = simpleKey(levels(barley$year), space = "right"),
        xlab = "Barley Yield (bushels/acre) ",
        aspect=0.5, layout = c(2,3), ylab=NULL)
invisible(dev.off())


###################################################
### code chunk number 17: search
###################################################
search()
base::log(1:3)


###################################################
### code chunk number 18: package
###################################################
library(useR2011)
sessionInfo()


###################################################
### code chunk number 19: help-start (eval = FALSE)
###################################################
## help.start()


###################################################
### code chunk number 20: help (eval = FALSE)
###################################################
## ?data.frame
## ?lm
## ?anova                 # a generic function
## ?anova.lm              # an S3 method, specialized for 'lm' objects


###################################################
### code chunk number 21: S3-interactive
###################################################
methods(anova)
methods(class="lm")


###################################################
### code chunk number 22: S3-view (eval = FALSE)
###################################################
## anova.lm
## getAnywhere("anova.lme")


###################################################
### code chunk number 23: head-src
###################################################
utils::head
methods(head)
head(head.matrix)


###################################################
### code chunk number 24: S4
###################################################
showMethods(complement)


###################################################
### code chunk number 25: S4-showMethods (eval = FALSE)
###################################################
## showMethods(class="DNAStringSet", where=getNamespace("Biostrings"))


###################################################
### code chunk number 26: S4-help (eval = FALSE)
###################################################
## class ? DNAStringSet
## method ? "complement,DNAStringSet"


###################################################
### code chunk number 27: S4-view (eval = FALSE)
###################################################
## selectMethod(complement, "DNAStringSet")


###################################################
### code chunk number 28: browseVignettes (eval = FALSE)
###################################################
## browseVignettes("Rsamtools")


###################################################
### code chunk number 29: scavenge (eval = FALSE)
###################################################
## ?library
## library(Biostrings)
## ?alphabetFrequency
## class?GappedAlignments
## browseVignettes("GenomicRanges")


