### R code from vignette source 'morgan-pwms.Rnw'

###################################################
### code chunk number 1: setup
###################################################
options(showHeadLines=2, showTailLines=1, max.print=1000, width=50)
library(Morgan2013)
library(Biostrings)
library(BSgenome.Dmelanogaster.UCSC.dm3)
library(MotifDb)
library(seqLogo)


###################################################
### code chunk number 2: HNF4alpha
###################################################
library(Biostrings)
data(HNF4alpha)
HNF4alpha


###################################################
### code chunk number 3: HNF4alpha-consensusMatrix
###################################################
consensusMatrix(HNF4alpha)[1:4,1:7]


###################################################
### code chunk number 4: HNF4alpha-PFM
###################################################
pwm <- PWM(consensusMatrix(HNF4alpha)[1:4,])
round(pwm, 3)[,1:7]


###################################################
### code chunk number 5: pwm-example
###################################################
library(Biostrings)
data(HNF4alpha)
pfm <- consensusMatrix(HNF4alpha)
pwm <- PWM(consensusMatrix(HNF4alpha))


###################################################
### code chunk number 6: seqlogo
###################################################
pdf("seqlogo.pdf", width=7, height=3)
pfm1 <- sweep(pfm, 2, colSums(pfm), "/")[1:4,]
seqLogo(pfm1)
x <- dev.off()


###################################################
### code chunk number 7: hits
###################################################
library(BSgenome.Dmelanogaster.UCSC.dm3)
hits <- matchPWM(pwm, Dmelanogaster$chr3R)
length(hits)
head(hits)


###################################################
### code chunk number 8: pwm-score
###################################################
scores <- 
  PWMscoreStartingAt(
    pwm, subject(hits), 
    start(hits))
hist(scores)


###################################################
### code chunk number 9: pwm-scores
###################################################
pdf("scores.pdf")
hist(scores, cex.axis=2)
x <- dev.off()


