### R code from vignette source 'D3_Visualization.Rnw'

###################################################
### code chunk number 1: Gviz
###################################################
library(Gviz)
data(cpgIslands)
chr <- "chr7"
genome <- "hg19"


###################################################
### code chunk number 2: AnnotationTrack
###################################################
atrack <- AnnotationTrack(cpgIslands, name="CpG")
plotTracks(atrack)


###################################################
### code chunk number 3: GenomeAxisTrack
###################################################
gtrack <- GenomeAxisTrack()
plotTracks(list(gtrack, atrack))


###################################################
### code chunk number 4: IdeogramTrack
###################################################
itrack <- IdeogramTrack(genome=genome, chromosome=chr)
plotTracks(list(itrack, gtrack, atrack))


###################################################
### code chunk number 5: GeneRegionTrack
###################################################
data(geneModels)
grtrack <- 
    GeneRegionTrack(geneModels, genome=genome,
                    chromosome=chr, name="Gene Model")
tracks <- list(itrack, gtrack, atrack, grtrack)
plotTracks(tracks)


###################################################
### code chunk number 6: Gviz-zoom
###################################################
plotTracks(tracks, from=2.5e7, to=2.8e7)


###################################################
### code chunk number 7: Gviz-sequence
###################################################
library(BSgenome.Hsapiens.UCSC.hg19)
strack <- SequenceTrack(Hsapiens, chromosome=chr)
plotTracks(c(tracks, strack), from=26450430, to=26450490, cex=.8)


###################################################
### code chunk number 8: Gviz-data
###################################################
## some data
lim <- c(26700000, 26900000)
coords <- seq(lim[1], lim[2], 101)
dat <- runif(length(coords) - 1, min=-10, max=10)

## DataTrack
dtrack <- 
    DataTrack(data=dat, start=coords[-length(coords)],
              end= coords[-1], chromosome=chr, genome=genome,
              name="Uniform Random")
plotTracks(c(tracks, dtrack))


###################################################
### code chunk number 9: Gviz-figure
###################################################
pdf("GvizFigure.pdf")
plotTracks(c(tracks, dtrack))
xx <- capture.output(dev.off())


###################################################
### code chunk number 10: shiny-loc (eval = FALSE)
###################################################
## system.file(package="Morgan2013", "shiny")


###################################################
### code chunk number 11: shiny-server (eval = FALSE)
###################################################
## library(shiny)
## runApp("~/shiny/se-app0")


