## http://www.ebi.ac.uk/arrayexpress/experiments/E-MTAB-1147/

## data and annotation sources

fls <- dir(".", pattern="bam$")
## library(RNAseqData.HNRNPC.bam.chr14)
## RNAseqData.HNRNPC.bam.chr14_BAMFILES
names(fls) <- sub("_chr14.bam", "", fls)

library(TxDb.Hsapiens.UCSC.hg19.knownGene)
ex <- exonsBy(TxDb.Hsapiens.UCSC.hg19.knownGene, "gene")

## count overlaps

library(GenomicRanges)
library(Rsamtools)
counts <- summarizeOverlaps(ex, fls)

## differential expression

library(DESeq2)
dds <- DESeqDataSet(counts, ~ Replicate + Treatment)
dds <- DESeq(dds)
res <- results(dds)

## annotation

library(org.Hs.eg.db)
anno <- select(org.Hs.eg.db, rownames(res), c("SYMBOL", "GENENAME"))
res <- cbind(res, anno)

## packages used

sessionInfo()
