
## ----r-solutions-1-------------------------------------------------------
f0 <- function(x, n)
    which(x >= sort(x, decreasing=TRUE)[n], arr.ind=TRUE)


## ----r-solutions-2-------------------------------------------------------
f1 <- function(x, n)
    which(x >= -sort(-x, partial=n)[n], arr.ind=TRUE)


## ----top_i_pq-source, eval=FALSE-----------------------------------------
## system.file(package="UnderstandingRBioc", "extdata", "top_i_pq.cpp")


## ----final-output--------------------------------------------------------
library(microbenchmark)
library(Rcpp)

fl <- system.file(package="UnderstandingRBioc", "extdata",
    "top_i_pq.cpp")
sourceCpp(fl)

n <- 10000
x <- rnorm(1e7)

res0 <- f0(x, n); res1 <- f1(x, n); res2 <- top_i_pq(x, n)
identical(res0, res1)
identical(res0, res2)
identical(res0, sort(res2))

times <- microbenchmark(f0(x, n), f1(x, n), top_i_pq(x, n), times=5)
print(times)
plot(times)


