
## ----knitr-settings, echo=FALSE------------------------------------------
library(knitr)
opts_chunk$set(tidy=FALSE, cache=TRUE)


## ----select, eval=FALSE--------------------------------------------------
## library(org.Hs.eg.db)
## keytypes(org.Hs.eg.db)
## columns(org.Hs.eg.db)
## egid <-
##   select(org.Hs.eg.db, "BRCA1", "ENTREZID", "SYMBOL")


## ----cdsBy, eval=FALSE---------------------------------------------------
## library(TxDb.Hsapiens.UCSC.hg19.knownGene)
## txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
## cdsByTx <- cdsBy(txdb, "tx")


## ----extactTranscriptsFromGenome, eval=FALSE-----------------------------
## library(BSgenome.Hsapiens.UCSC.hg19)
## library(GenomicFeatures)
## dna <- extractTranscriptsFromGenome(Hsapiens, cdsByTx)


## ----biomart, eval=FALSE-------------------------------------------------
## library(biomaRt)
## ensembl <-                      ## discover & use
##    useMart("ensembl", dataset="hsapiens_gene_ensembl")
## head(listFilters(ensembl), 3)
## myFilter <- "chromosome_name"
## myValues <- c("21", "22")
## myAttributes <- c("ensembl_gene_id","chromosome_name")
## res <-
##     getBM(attributes=myAttributes, filters=myFilter,
##           values=myValues, mart=ensembl)


## ----psicquic, eval=FALSE------------------------------------------------
## library(PSICQUIC)
## ## Query web service for available providers
## psicquic <- PSICQUIC()
## providers(psicquic)         # 25 available providers
## ## interactions between TP53 and MYC
## tbl <-
##     interactions(psicquic, c("TP53", "MYC"), "9606")
## nrow(tbl)                   # 7 interactions


## ----AnnotationHub, eval=FALSE-------------------------------------------
## library(AnnotationHub)
## hub <- AnnotationHub()
## hub        ## 10511 resources


