
## ----R-figures, eval=TRUE, tidy=FALSE, fig.keep="none"-------------------
## Two 'vectors'
x <- rnorm(1000)
y <- x + rnorm(1000, sd=.5)
## Integrated container
df <- data.frame(X=x, Y=y)
## Visualize
plot(Y ~ X, df)
## Regression; 'object'
fit <- lm(Y ~ X, df)
## Methods on the object
abline(fit) # regression line
anv <- anova(fit) # ANOVA table


## ----installed-packages--------------------------------------------------
library(parallel)


## ----biocLite, eval=FALSE------------------------------------------------
## source("http://bioconductor.org/biocLite.R")
## biocLite("IRanges")
## library("IRanges")


## ----search--------------------------------------------------------------
head(search(), 3)


## ----package-help, eval=FALSE--------------------------------------------
## help(package="IRanges")


