
## ----GRanges-setup, echo=FALSE-------------------------------------------
suppressPackageStartupMessages({
    library(knitr)
    library(GenomicRanges)
})
opts_chunk$set(cache=TRUE, tidy=FALSE)


## ----ranges, tidy=FALSE--------------------------------------------------
library(IRanges)
eg <- IRanges(start= c(1, 10, 20), 
              end  = c(4, 10, 19), 
              names= c("A", "B", "C"))
## bigger
start <- floor(runif(10000, 1, 1000))
end <- start + floor(runif(10000, 0, 100))
ir <- IRanges(start, end)


## ----ranges-accessors----------------------------------------------------
length(ir)
ir[1:4]
start(ir[1:4])
ir[width(ir) > 10 & width(ir) < 20]


## ----ranges-ops----------------------------------------------------------
ir <- IRanges(start=c(7, 9, 12, 14, 22:24),
              end=c(15, 11, 12, 18, 26, 27, 28))
shift(ir, 1)
rir <- reduce(ir)
findOverlaps(ir, rir)


## ----IRangesList---------------------------------------------------------
irl <- split(ir, width(ir))
reduce(irl)


## ----GRanges-simple------------------------------------------------------
library(GenomicRanges)
genes <- GRanges(seqnames=c("chr3R", "chrX"),
    ranges=IRanges(
      start=c(19967117, 18962306),
      end  =c(19973212, 18962925),
      names=c("FBgn0039155", "FBgn0085359")),
    strand=c("+", "-"),
    seqlengths=c(chr3R=27905053L, chrX=22422827L))
mcols(genes) <- 
    DataFrame(EntrezId=c("42865", "2768869"),
              Symbol=c("kal-1", "CG34330"))


## ----GRanges-accessors---------------------------------------------------
width(genes)
genes$Symbol


## ----GRanges-operations--------------------------------------------------
flank(genes, 1000)  ## 5' flanking range


## ----List----------------------------------------------------------------
rl <- splitAsList(1:5, c("A", "B", "A", "B", "B"))
elementLengths(rl)
log(rl)


