test_that("isSimpleVariant works correctly on simple data", {
    ## construct a minimal VCF object
    rowData <- GRanges("chr1", IRanges(rep(1, 4), width=1))
    alt <- DNAStringSet(rep("A", 4))
    fixed <- DataFrame(REF=DNAStringSet(c("A", "A", "AT", "")),
                       ALT=unname(split(alt, 1:4)),
                       QUAL=NA_real_, FILTER=NA_character_)
    vcf <- VariantAnnotation::VCF(rowData, fixed=fixed)
    expect_that(isSimpleVariant(vcf),
                equals(c(TRUE, TRUE, FALSE, FALSE)))

    alt <- DNAStringSet(c("A", "A", "A", "AT", ""))
    fixed <- DataFrame(REF=DNAStringSet("A"),
                       ALT=unname(split(alt, c(1, 2, 2, 3, 4))),
                       QUAL=NA_real_, FILTER=NA_character_)
    vcf <- VariantAnnotation::VCF(rowData, fixed=fixed)
    expect_that(isSimpleVariant(vcf),
                equals(c(TRUE, FALSE, FALSE, FALSE)))
})

test_that("isSimpleVariant works correctly on realistic data", {
    fl <- system.file(package="VariantAnnotation", "extdata", 
                      "chr22.vcf.gz")
    vcf <- readVcf(fl, "hg19")
    expect_that(sum(isSimpleVariant(vcf)), equals(9969))
})

test_that("isSimpleVariant edge cases return correct values", {
    vcf <- VariantAnnotation::VCF()
    expect_that(length(isSimpleVariant(vcf)), equals(0))
})

test_that("isSimpleVariant fails on incorrect input", {
    expect_error(isSimpleVariant(1), 'is(vcf, "VCF") is not TRUE')
})
