\name{isSimpleVariant}
\alias{isSimpleVariant}
\title{Test whether ref() and alt() are single nucleotides}
\usage{
isSimpleVariant(vcf)
}
\arguments{
  \item{vcf}{input VCF object}
}
\value{
logical vector of length(vcf) indicating whether variant is
simple
}
\description{
This function takes a 'VCF' object and returns a logical
vector indicating whether variants are 'simple'. A simple
variant is one where (a) the REF allele is a single
character; (b) the is only one ALT allele; and (c) the ALT
allele is a single character
}
\examples{
library(VariantAnnotation)
fl <- system.file(package="VariantAnnotation", "extdata",
   "chr22.vcf.gz")
vcf <- readVcf(fl, "hg19")
table(isSimpleVariant(vcf))
vcf[isSimpleVariant(vcf)]    # select simple variants only
}

