
## ----style, eval=TRUE, echo=FALSE, results="asis"------------------------
stopifnot(BiocInstaller::biocVersion() == "2.13")
BiocStyle::latex()
library(knitr)
opts_chunk$set(cache=TRUE, tidy=FALSE)


## ----packages, eval=TRUE, echo=FALSE, warning=FALSE, message=FALSE-------
suppressPackageStartupMessages({
    library(VariantAnnotation)
    library(AnnotationHub)
})


## ----chr7-subset---------------------------------------------------------
library(VariantAnnotation)
fl <- system.file("extdata", "chr7-sub.vcf.gz", 
                  package="VariantAnnotation")
vcf <- readVcf(fl, "hg19")


## ----filter-isSnp--------------------------------------------------------
isSimpleRef <- nchar(ref(vcf)) == 1
isSimpleAlt <- 
    ## 'sapply': apply a function to each ALT record
    ## 'length(elt) == 1: the record has only one allele...
    ## 'nchar(elt) == 1: ... and the allele is a single character
    sapply(alt(vcf), function(elt) (length(elt) == 1) && nchar(elt) == 1)
keep <- isSimpleRef & isSimpleAlt
vcf <- vcf[keep]
nrow(vcf)


