library(shiny)
library(lattice)
    
shinyServer(function(input, output) {

    output$toptable <- renderTable({
        if (is.null(input$datafile))
            return(NULL)
        read.csv(input$datafile$datapath)
    })

    output$volcano <- renderPlot({
        if (is.null(input$datafile))
            return(NULL)
        csv <- read.csv(input$datafile$datapath)
        print(xyplot(-log10(pvalue) ~ log2FoldChange, csv))
    })
})
