Learning R / Bioconductor for Sequence Analysis
===============================================

Genentech, San Francisco, CAA<br />
2-3 February 2015

Contact: Martin Morgan ([mtmorgan@fhcrc.org](mailto:mtmorgan@fhcrc.org))

This course is directed at beginning and intermediate users who would
like an introduction to the analysis and comprehension of
high-throughput sequence data using _R_ and
_[Bioconductor](http://bioconductor.org)_. Day 1 focuses on learning
essential background: an introduction to the _R_ programming language;
central concepts for effective use of _Bioconductor_ software; and an
overview of high-throughput sequence analysis work flows. The morning
of Day 2 emphasizes use of _Bioconductor_ for specific tasks, and in
particular takes detailed look at RNA-seq differential expression work
flow.  The afternoon of Day 2 transitions to understanding effective
approaches for managing larger challenges: strategies for working with
large data, writing re-usable functions, developing reproducible
reports and work flows, and visualizing results.  The course combines
lectures with extensive hands-on practicals; participants are required
to bring a laptop with wireless internet access and a modern version
of the Chrome or Safari web browser.

Schedule (tentative)
--------------------

Day 1: Learn _R_ / _Bioconductor_

- 9:00 - 10:30 Introduction to _R_: objects, functions, help!
- 11:00 - 12:30 Introduction to _Bioconductor_: working with packages
  and classes
- 1:30 - 5:00 Introduction to sequence analysis: typical work flow;
  data types and quality assessment; essential _Bioconductor_ packages

Day 2: Use _R_ / _Bioconductor_ 

- 9:00 - 12:00 (break 10:30 - 10:45) An RNA-seq differential
  expression work flow (detail)
- 12:00 - 12:30 Other work flows (survey): ChIP-seq, variants, copy
  number, epigenomics
- 1:30 - 2:15 Working with large data
- 2:15 - 3:00 Organizing code in functions, files, and packages
- 3:15 - 4:00 Reproducible reports and work flows: markdown
- 4:00 - 4:45 Visualization
- 4:45 - 5:00 Summary
