## ----setup, echo=FALSE---------------------------------------------------
suppressPackageStartupMessages({
    library(UseBioconductor)
    library(GenomicRanges)
})
stopifnot(BiocInstaller::biocVersion() == "3.1")

## ----style, echo = FALSE, results = 'asis'-------------------------------
BiocStyle::markdown()
knitr::opts_chunk$set(tidy=FALSE)

## ------------------------------------------------------------------------
library(GenomicRanges)
showClass("GRangesList")

## ------------------------------------------------------------------------
library(TxDb.Dmelanogaster.UCSC.dm3.ensGene)
txdb <- TxDb.Dmelanogaster.UCSC.dm3.ensGene
tx_by_gn <- transcriptsBy(txdb, by="gene")
unlisted <- unlist(tx_by_gn)
TSS <- ifelse(strand(unlisted) == "+", start(unlisted), end(unlisted))
TSS <- GRanges(seqnames(unlisted), IRanges(TSS, width=1), strand(unlisted))
TSS_by_gn <- relist(TSS, tx_by_gn)
mcols(TSS) <- mcols(unlisted)
TSS_by_gn <- relist(TSS, tx_by_gn) 

