## Model selection
##
## This code runs after the calculation of wSFEM, wSREM
## Why is the distribution of Q so different from Chi^2?
## Does this really mean the REM is better?
##
 npm = table(sign(wSFEM[, "MUvals"] -  wSREM[, "MUvals"]))
 binom.test(npm["1"], sum(npm[c("-1", "1")]))

## While the differences are not large, they are not
## random. A closer inspection shows that for \Sexpr{npm["1"]} genes the
## effect estimated from the fixed effects model is (slightly) larger,
## for \Sexpr{npm["-1"]} it is slightly smaller, and for 
## \Sexpr{npm["0"]}
## genes it is exactly the same as from the random effects model.
##
## Questions: Should one expect that the number of smaller and larger
## be the same, or is the current observation OK?


