load("ERBetas.RData")

## if the interaction and treatment effect are in the same direction
ERBetasList <- as.list(ERBetas)

interactionEffect <- sapply(ERBetasList, function(x) as.numeric(x$fixed[3]))
treatmentEffect <- sapply(ERBetasList, function(x) as.numeric(x$fixed[2]))

estMatrix <- as.matrix(cbind(treatmentEffect, interactionEffect))
Ncount <- c(
            sum(apply(estMatrix, 1, function(x) x[1]<0 && x[2]>0)),
            sum(apply(estMatrix, 1, function(x) x[1]>0 && x[2]>0)),
            sum(apply(estMatrix, 1, function(x) x[1]>0 && x[2]<0)),
            sum(apply(estMatrix, 1, function(x) x[1]<0 && x[2]<0))
            )

postscript("ER_TreatInter.ps", paper="letter")
plot(treatmentEffect, interactionEffect,
     xlab="Estimation of Treatment Effect", ylab="Estimation of Interaction",
     xlim=c(round(min(treatmentEffect, interactionEffect),1), round(max(treatmentEffect, interactionEffect),1)),
     ylim=c(round(min(treatmentEffect, interactionEffect),1), round(max(treatmentEffect, interactionEffect),1))
     )
abline(0,1)
abline(h=0, lty=2)
abline(v=0, lty=2)
title(paste("ER (Correlation =", round(cor(treatmentEffect, interactionEffect),6), ")\n(", Ncount[1], ",", Ncount[2], ",", Ncount[3], ",", Ncount[4], ")"))
dev.off()

## big \sigma^2_b
postscript("ER_sigma2b_hist.ps", paper="letter")
sigma2b <- sapply(ERBetasList, function(x) as.numeric(x$sigma2b))
hist(sigma2b,
     main="ER",
     xlab="sigma2b")
dev.off()

sigma2bCut <- 0.2
largeSigma2bIndex <- as.numeric(sapply(names(sigma2b[sigma2b>sigma2bCut]), function(x) which(names(treatmentEffect)==x) ))
hist(as.numeric(treatmentEffect[largeSigma2bIndex]))
hist(as.numeric(interactionEffect[largeSigma2bIndex]))


postscript("ER_TreatInter_LargeSigma2b.ps", paper="letter")
plot(treatmentEffect, interactionEffect,
     xlab="Estimation of Treatment Effect", ylab="Estimation of Interaction",
     xlim=c(round(min(treatmentEffect, interactionEffect),1), round(max(treatmentEffect, interactionEffect),1)),
     ylim=c(round(min(treatmentEffect, interactionEffect),1), round(max(treatmentEffect, interactionEffect),1))
     )
abline(0,1)
abline(h=0, lty=2)
abline(v=0, lty=2)
title(paste("ER (Correlation =", round(cor(treatmentEffect, interactionEffect),6), ")\n(", Ncount[1], ",", Ncount[2], ",", Ncount[3], ",", Ncount[4], ")"))
points(as.numeric(treatmentEffect[largeSigma2bIndex]), as.numeric(interactionEffect[largeSigma2bIndex]), col="red")
dev.off()
