library("nlme")
library("Biobase")
library("GeneMetaEx")

data("HolstegeLN")
data("NevinsLN")

geneN <- intersect(geneNames(HolstegeLN), geneNames(NevinsLN))

if(sum(geneNames(HolstegeLN) == geneNames(NevinsLN)) != length(geneN)) {
    stop("Genes not matched!!!\n")
}

treatment <- c(as.character(HolstegeLN$LNstatus), as.character(NevinsLN$LNstatus))
treatment <- factor(treatment)
#treatment <- as.numeric(treatment)

experiment <- factor(c(rep("Vant", length(sampleNames(HolstegeLN))),
                       rep("Nevins", length(sampleNames(NevinsLN)))
                       ))

expression <- cbind(exprs(HolstegeLN), exprs(NevinsLN))

##what we want to do now is to fit two different models,
##one with a random effect for the trt by expt interaction
##the other with a fixed effect, and then test, in both cases for the
##interaction to go away

##construct an interaction term
Intera = ifelse(treatment=="pos" & experiment=="Nevins", 1, 0)

LNpvs <- new.env()
for( i in 1:nrow(expression) ) {
    y <- as.vector(expression[i,])

    xlme <- lme(y ~ treatment + Intera,
                random = ~ 1 | experiment, method="ML")

    xlme2 <- lme(y ~ treatment,
                 random= ~ 1 | experiment, method="ML")

    rlme <- lme(y ~ treatment,
                random = ~1 | experiment/treatment, method="ML")


    LNpvs[[geneN[i]]] <- c(anova(xlme, xlme2)$"p-value"[2],
                           anova(rlme, xlme2)$"p-value"[2])

    if( i%%500 == 0 ) print(i)

}

save(LNpvs, file="LNpvs.RData")


pv1 = unlist(eapply(LNpvs, function(x) x[1]))
pv2 = unlist(eapply(LNpvs, function(x) x[2]))

postscript("LNplots.ps", paper="letter")
par(mfrow=c(2,2))

hist(pv1, ylim=c(0,3000), main="p-values from \n fixed interaction effect")
hist(pv2, ylim=c(0,3000), main="p-values from \n random interaction effect")
plot(pv1, pv2, main="Comparison of p-values",
     xlab="p-values fixed interaction effect",
     ylab ="p-values random interaction effect")

discord = function(v1, v2, p) {
    if(p < 0 || p>1) stop("bad value for p")
    sum(v1 < p & v2 < p)/(sum(v1<p) + sum(v2<p))
}

dc=NULL
for(p in seq(0.001, .05, by=.001)) dc = c(discord(pv1,pv2, p), dc)

plot(seq(0.001, .05, by=.001), dc, type="l", col="red",
     xlab="p-value", ylab="Concordance",
     main="Discordance as a \n function of p-value")

dev.off()

##now we compare these two sets of p-values - they seem related;
##if so then we can proceed to think about what comes next
## one approach is to look at those which have a non-zero interaction
## and from these those which have a significant treatment effect
## - then compare that to the individual estimates (lmList seems like
## it might help here)

 ##we use those that have a p-value > 0.05 in pv2, as the ones that
 ## should have no interaction term. Now we compare them on the basis
 ## of whether we find a significant effect in exp1, in exp2 or in
 ## both

 goodG = pv1>0.05

 LNbetacomp <- new.env()
 for( i in 1:nrow(expression)) {
    if(goodG[i] ) {
        y <- as.vector(expression[i,])
        xlme <- lme(y ~ treatment,
                  random = ~ 1 | experiment, method="ML")

        xlme2 <- lme(y~ 1, random=~1 | experiment, method="ML")

        nev = experiment=="Nevins"
        yn = y[nev]; xn = treatment[nev]
        yv = y[!nev]; xv = treatment[!nev]
        mn1 = lm(yn~xn); mn2 = lm(yn~1);
        mv1 = lm(yv~xv); mv2 = lm(yv~1);

        LNbetacomp[[geneN[i]]] <- list(pvalues=
                                       c(anova(xlme, xlme2)$"p-value"[2],
                                         anova(mn1,mn2)$"Pr"[2],
                                         anova(mv1,mv2)$"Pr"[2]),
                                       coef =
                                       c(coef(xlme)[1,2],
                                         coef(mn1)[2], coef(mv1)[2] ))
    }
    if( i%%500 == 0 ) print(i)

}

save(LNbetacomp, file="LNbetacomp.RData")

pvB1 = unlist(eapply(LNbetacomp, function(x) x$pvalues[1]))
pvB2 = unlist(eapply(LNbetacomp, function(x) x$pvalues[2]))
pvB3 = unlist(eapply(LNbetacomp, function(x) x$pvalues[3]))

sum(pvB1 < 0.01 & ( pvB2 > 0.01 & pvB3 > 0.01))

intg = pvB1 < 0.01 & ( pvB2 > 0.01 & pvB3 > 0.01)

cvB1 = unlist(eapply(LNbetacomp, function(x) x$coef[1]))
cvB2 = unlist(eapply(LNbetacomp, function(x) x$coef[2]))
cvB3 = unlist(eapply(LNbetacomp, function(x) x$coef[3]))


x1 = cvB1[intg]
x2 = cvB2[intg]
x3 = cvB3[intg]

postscript("LNpairs.ps", paper="letter")
pairs(cbind(x1,x2,x3))
dev.off()

sum(pvB1 < 0.01 & pvB2 < 0.01 & pvB3 < 0.01)



