load("LNBetas.RData")

## if the interaction and treatment effect are in the same direction
LNBetasList <- as.list(LNBetas)

interactionEffect <- sapply(LNBetasList, function(x) as.numeric(x$fixed[3]))
treatmentEffect <- sapply(LNBetasList, function(x) as.numeric(x$fixed[2]))

estMatrix <- as.matrix(cbind(treatmentEffect, interactionEffect))
Ncount <- c(
            sum(apply(estMatrix, 1, function(x) x[1]<0 && x[2]>0)),
            sum(apply(estMatrix, 1, function(x) x[1]>0 && x[2]>0)),
            sum(apply(estMatrix, 1, function(x) x[1]>0 && x[2]<0)),
            sum(apply(estMatrix, 1, function(x) x[1]<0 && x[2]<0))
            )

postscript("LN_TreatInter.ps", paper="letter")
plot(treatmentEffect, interactionEffect,
     xlab="Estimation of Treatment Effect", ylab="Estimation of Interaction",
     xlim=c(round(min(treatmentEffect, interactionEffect),1), round(max(treatmentEffect, interactionEffect),1)),
     ylim=c(round(min(treatmentEffect, interactionEffect),1), round(max(treatmentEffect, interactionEffect),1))
     )
abline(0,1)
abline(h=0, lty=2)
abline(v=0, lty=2)
title(paste("LN (Correlation =", round(cor(treatmentEffect, interactionEffect),6), ")\n(", Ncount[1], ",", Ncount[2], ",", Ncount[3], ",", Ncount[4], ")"))
dev.off()


## big \sigma^2_b
postscript("LN_sigma2b_hist.ps", paper="letter")
sigma2b <- sapply(LNBetasList, function(x) as.numeric(x$sigma2b))
hist(sigma2b,
     main="LN",
     xlab="sigma2b")
dev.off()

postscript("LN_TreatInter_LargeSigma2b.ps", paper="letter")
plot(treatmentEffect, interactionEffect,
     xlab="Estimation of Treatment Effect", ylab="Estimation of Interaction",
     xlim=c(round(min(treatmentEffect, interactionEffect),1), round(max(treatmentEffect, interactionEffect),1)),
     ylim=c(round(min(treatmentEffect, interactionEffect),1), round(max(treatmentEffect, interactionEffect),1))
     )
abline(0,1)
abline(h=0, lty=2)
abline(v=0, lty=2)
title(paste("LN (Correlation =", round(cor(treatmentEffect, interactionEffect),6), ")\n(", Ncount[1], ",", Ncount[2], ",", Ncount[3], ",", Ncount[4], ")"))
points(as.numeric(treatmentEffect[largeSigma2bIndex]), as.numeric(interactionEffect[largeSigma2bIndex]), col="red")
dev.off()

