library("nlme")
library("Biobase")
library("GeneMetaEx")

data("VantER")
data("NevinsER")

geneN <- intersect(geneNames(VantER), geneNames(NevinsER))

if(sum(geneNames(VantER) == geneNames(NevinsER)) != length(geneN)) {
    stop("Genes not matched!!!\n")
}

treatment <- c(as.character(VantER$ERstatus), as.character(NevinsER$ERstatus))
treatment <- factor(treatment)
#treatment <- as.numeric(treatment)

experiment <- factor(c(rep("Vant", length(sampleNames(VantER))),
                       rep("Nevins", length(sampleNames(NevinsER)))
                       ))

expression <- cbind(exprs(VantER), exprs(NevinsER))

ERBetas <- new.env()
for( i in 1:(dim(expression)[1])) {
    x <- as.vector(expression[i,])
    gdata <- groupedData( x ~ treatment | experiment )
    xlme <- lme(x ~ treatment + treatment:experiment, data=gdata, 
                  random = ~ 1 | experiment)

    ERBetas[[geneN[i]]] <- xlme$coef
    varcorr <- VarCorr(xlme)
    ERBetas[[geneN[i]]]$sigma2  <- as.numeric(varcorr[1])
    ERBetas[[geneN[i]]]$sigma2b <- as.numeric(varcorr[2])
}

save(ERBetas, file="ERBetas.RData")
