library("nlme")
library("GeneMetaEx")

data("VantER")
data("NevinsER")

geneN <- intersect(geneNames(VantER), geneNames(NevinsER))

if(sum(geneNames(VantER) == geneNames(NevinsER)) != length(geneN)) {
    stop("Genes not matched!!!\n")
}

treatment <- c(as.character(VantER$ERstatus), as.character(NevinsER$ERstatus))
treatment <- factor(treatment)
#treatment <- as.numeric(treatment)

experiment <- factor(c(rep("Vant", length(sampleNames(VantER))),
                       rep("Nevins", length(sampleNames(NevinsER)))
                       ))

expression <- cbind(exprs(VantER), exprs(NevinsER))

interaction = ifelse(treatment=="pos" & experiment=="Nevins", 1, 0)

ERpars <- new.env()
for( i in 1:(dim(expression)[1])) {
    y <- as.vector(expression[i,])
    ## xlme: fixed effect lme
    xlme <- lme(y ~ treatment + interaction,
                random = ~ 1 | experiment, method="ML")
    ERpars[[geneN[i]]]$xlme$fixef <- fixef(xlme)
    ERpars[[geneN[i]]]$xlme$ranef <- ranef(xlme)
    ERpars[[geneN[i]]]$xlme$VarCorr <- VarCorr(xlme)

    ## rlme: random effect lme
    rlme <- lme(y ~ treatment,
                random = ~1 | experiment/treatment, method="ML")
    ERpars[[geneN[i]]]$rlme$fixef <- fixef(rlme)
    ERpars[[geneN[i]]]$rlme$ranef <- ranef(rlme)
    ERpars[[geneN[i]]]$rlme$VarCorr <- VarCorr(rlme)
}

save(ERpars, file="ERpars.RData")
