library("nlme")
library("Biobase")
library("GeneMetaEx")

data("HolstegeLN")
data("NevinsLN")

geneN <- intersect(geneNames(HolstegeLN), geneNames(NevinsLN))

if(sum(geneNames(HolstegeLN) == geneNames(NevinsLN)) != length(geneN)) {
    stop("Genes not matched!!!\n")
}

treatment <- factor(c(as.character(HolstegeLN$LNstatus), 
   as.character(NevinsLN$LNstatus)))

experiment <- factor(c(rep("Holstege", length(sampleNames(HolstegeLN))),
                       rep("Nevins", length(sampleNames(NevinsLN)))
                       ))

expression <- cbind(exprs(HolstegeLN), exprs(NevinsLN))

LNBetas <- new.env()
for( i in 1:(dim(expression)[1])) {
    x <- as.vector(expression[i,])
    gdata <- try(groupedData( x ~ 1 | experiment ))
    if(inherits(gdata, "try-error")) {
        stop("groupedData error!!!\n")
    }
    xlme <- lme(x ~ treatment + treatment:experiment, data=gdata, random = ~ 1 | experiment)
    LNBetas[[geneN[i]]] <- xlme$coef
    varcorr <- VarCorr(xlme)
    LNBetas[[geneN[i]]]$sigma2  <- as.numeric(varcorr[1])
    LNBetas[[geneN[i]]]$sigma2b <- as.numeric(varcorr[2])
}

save(LNBetas, file="LNBetas.RData")
