\name{HNSCCpredictors}
\alias{HNSCCpredictors}
\docType{data}
\title{HNSCC Predictors}
\description{
  A list of 102 genes implicated in the prediction of lymph node
  metastases in patients with head and neck cancer.
}
\usage{data(HNSCCpredictors)}
\format{
  A data frame with 102 observations on the following 3 variables.
  \describe{
    \item{\code{Symbol}}{A character vector containing the gene symbols.}
    \item{\code{GenBank ID}}{A character vector containing the GenBank IDs.}
    \item{\code{Direction}}{A character vector of \code{pos} indicating
      a positive association with lymph node involvement and \code{neg}
      indicateing a negative relationship.}
  }
}
\details{
  Roepman et al identified 102 genes that were predictors of lymph node
  status. Those identified as \code{pos} tend to be higher in patients
  with positive lymph node involvement.

  Note that Roepman et al report that misclassification rates are quite
  high, about 10\% for lymph node metastases and up to 30\% for those
  classified as having no lymph node involvement.
}
\source{
 From Table 2 of the Supplementary materials.
}
\references{
Nature Genetics  37, 182 - 186 (2005)
An expression profile for diagnosis of lymph node metastases from
primary head and neck  squamous cell carcinomas.
Paul Roepman, Lodewyk F A Wessels, Nienke Kettelarij, Patrick Kemmeren,
Antony J Miles, Philip Lijnzaad, Marcel G J Tilanus, Ronald Koole,
Gert-Jan Hordijk, Peter C van der Vliet, Marcel J T Reinders, Piet J
Slootweg & Frank C P Holstege 
}
\examples{
data(HNSCCpredictors)
table(HNSCCpredictors$Direction)
}
\keyword{datasets}
