% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_integrate_regions.R
\name{nmr_integrate_peak_positions}
\alias{nmr_integrate_peak_positions}
\title{Integrate peak positions}
\usage{
nmr_integrate_peak_positions(
  samples,
  peak_pos_ppm,
  peak_width_ppm = 0.006,
  ...
)
}
\arguments{
\item{samples}{A \link{nmr_dataset} object}

\item{peak_pos_ppm}{The peak positions, in ppm}

\item{peak_width_ppm}{The peak widths (or a single peak width for all peaks)}

\item{...}{
  Arguments passed on to \code{\link[=nmr_integrate_regions]{nmr_integrate_regions}}
  \describe{
    \item{\code{regions}}{A named list. Each element of the list is a region,
given as a named numeric vector of length two with the range
to integrate. The name of the region will be the name of the
column}
  }}
}
\value{
Integrate peak positions
}
\description{
The function allows the integration of a given ppm vector with a specific width.
}
\seealso{
Other peak integration functions: 
\code{\link{Pipelines}},
\code{\link{get_integration_with_metadata}()},
\code{\link{nmr_identify_regions_blood}()},
\code{\link{nmr_identify_regions_cell}()},
\code{\link{nmr_identify_regions_urine}()},
\code{\link{nmr_integrate_regions}()}

Other nmr_dataset_1D functions: 
\code{\link{[.nmr_dataset_1D}()},
\code{\link{format.nmr_dataset_1D}()},
\code{\link{get_integration_with_metadata}()},
\code{\link{is.nmr_dataset_1D}()},
\code{\link{nmr_integrate_regions}()},
\code{\link{nmr_meta_add}()},
\code{\link{nmr_meta_export}()},
\code{\link{nmr_meta_get}()},
\code{\link{nmr_meta_get_column}()},
\code{\link{nmr_ppm_resolution}()},
\code{\link{print.nmr_dataset_1D}()}
}
\concept{nmr_dataset_1D functions}
\concept{peak integration functions}
