% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tr2g.R
\name{sort_tr2g}
\alias{sort_tr2g}
\title{Sort transcripts to the same order as in kallisto index}
\usage{
sort_tr2g(tr2g, file, kallisto_out_path)
}
\arguments{
\item{tr2g}{The data frame output from the \code{tr2g_*} family of functions.}

\item{file}{Character vector of length 1, path to a tsv file with
transcript IDs and the corresponding gene IDs, in the format required for
\code{bustools}, or written by \code{\link{save_tr2g_bustools}}.}

\item{kallisto_out_path}{Character vector of length 1, path to the directory
for the outputs of kallisto bus.}
}
\value{
A data frame with columns \code{transcript} and \code{gene} and the
other columns present in \code{tr2g} or the data frame in \code{file}, with
the transcript IDs sorted to be in the same order as in the kallisto index.
}
\description{
This function takes the data frame output from the \code{tr2g_*} family of
functions in this package as the input, and sorts it so the transcripts are
in the same order as in the kallisto index used to generate the \code{bus}
file. Sorting is vital to obtain the correct sparse matrix from the \code{bus}
file as equivalence class notations are based on the index of transcripts
in the kallisto index.
}
\details{
Since the attribute field of GTF and GFF3 files varies across sources, output
from \code{\link{tr2g_gtf}} and \code{\link{tr2g_gff3}} may need further
clean up. You may also supply gene and transcript IDs from other sources.
This function should be used after the clean up, when the transcript IDs in
the cleaned up data frame have the same format as those in \code{transcript}
}
\note{
This function has been superseded by the new version of tr2g_*
functions that can extract transcriptome for only the biotypes specified and
with only the standard chromosomes. The new version of tr2g_* functions also
sorts the transcriptome so the tr2g and the transcriptome have transcripts in
the same order.
}
\examples{
toy_path <- system.file("testdata", package = "BUSpaRse")
file_use <- paste(toy_path, "gtf_test.gtf", sep = "/")
tr2g <- tr2g_gtf(file = file_use, get_transcriptome = FALSE,
  write_tr2g = FALSE, save_filtered_gtf = FALSE, transcript_version = NULL)
tr2g <- sort_tr2g(tr2g, kallisto_out_path = toy_path)
}
\seealso{
Other functions to retrieve transcript and gene info: 
\code{\link{tr2g_EnsDb}()},
\code{\link{tr2g_TxDb}()},
\code{\link{tr2g_ensembl}()},
\code{\link{tr2g_fasta}()},
\code{\link{tr2g_gff3}()},
\code{\link{tr2g_gtf}()},
\code{\link{transcript2gene}()}
}
\concept{functions to retrieve transcript and gene info}
