% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{read_count_output}
\alias{read_count_output}
\title{Read matrix along with barcode and gene names}
\usage{
read_count_output(dir, name, tcc = FALSE)
}
\arguments{
\item{dir}{Directory with the bustools count outputs.}

\item{name}{The files in the output directory should be "name".mtx, "name".genes.txt,
and "name".barcodes.txt.}

\item{tcc}{Logical, whether the matrix of interest is a TCC matrix. Defaults
to \code{FALSE}.}
}
\value{
A dgCMatrix with barcodes as column names and genes as row names.
}
\description{
This function takes in a directory and name and reads the mtx file, genes,
and barcodes from the output of \code{bustools} to return a sparse matrix with
column names and row names.
}
\examples{
# Internal toy data used for unit testing
toy_path <- system.file("testdata", package = "BUSpaRse")
m <- read_count_output(toy_path, name = "genes", tcc = FALSE)
}
