% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{read_velocity_output}
\alias{read_velocity_output}
\title{Read intronic and exonic matrices into R}
\usage{
read_velocity_output(spliced_dir, unspliced_dir, spliced_name, unspliced_name)
}
\arguments{
\item{spliced_dir}{Directory with \code{mtx} file for UMI counts of spliced
transcripts.}

\item{unspliced_dir}{Directory with \code{mtx} file for UMI counts of unspliced
transcripts.}

\item{spliced_name}{The files in the splicedd directory should be
<spliced_name>.mtx, <spliced_name>.genes.txt, and
<spliced_name>.barcodes.txt.}

\item{unspliced_name}{The files in the unsplicedd directory should be
<unspliced_name>.mtx, <unspliced_name>.genes.txt, and
<unspliced_name>.barcodes.txt.}
}
\value{
A list of two dgCMatrix with barcodes as column names and genes as
row names. The elements of the list will be \code{spliced} and \code{unspliced}.
}
\description{
Read intronic and exonic matrices into R
}
\examples{
# Internal toy data used for unit testing
toy_path <- system.file("testdata", package = "BUSpaRse")
m <- read_velocity_output(toy_path, toy_path,
  spliced_name = "genes",
  unspliced_name = "genes")
}
