% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tr2g.R
\name{tr2g_GRanges}
\alias{tr2g_GRanges}
\title{Get transcript and gene info from GRanges}
\usage{
tr2g_GRanges(
  gr,
  Genome = NULL,
  get_transcriptome = TRUE,
  out_path = ".",
  write_tr2g = TRUE,
  transcript_id = "transcript_id",
  gene_id = "gene_id",
  gene_name = "gene_name",
  transcript_version = "transcript_version",
  gene_version = "gene_version",
  version_sep = ".",
  transcript_biotype_col = "transcript_biotype",
  gene_biotype_col = "gene_biotype",
  transcript_biotype_use = "all",
  gene_biotype_use = "all",
  chrs_only = TRUE,
  compress_fa = FALSE,
  save_filtered_gtf = TRUE,
  overwrite = FALSE
)
}
\arguments{
\item{gr}{A \code{\link{GRanges}} object. The metadata columns should be
atomic vectors, not lists.}

\item{Genome}{Either a \code{\link{BSgenome}} or a \code{\link{XStringSet}}
object of genomic sequences, where the intronic sequences will be extracted
from. Use \code{\link{genomeStyles}} to check which styles are supported for
your organism of interest; supported styles can be interconverted. If the
style in your genome or annotation is not supported, then the style of
chromosome names in the genome and annotation should be manually set to be
consistent.}

\item{get_transcriptome}{Logical, whether to extract transcriptome from
genome with the GTF file. If filtering biotypes or chromosomes, the filtered
\code{GRanges} will be used to extract transcriptome.}

\item{out_path}{Directory to save the outputs written to disk. If this
directory does not exist, then it will be created. Defaults to the current
working directory.}

\item{write_tr2g}{Logical, whether to write tr2g to disk. If \code{TRUE}, then
a file \code{tr2g.tsv} will be written into \code{out_path}.}

\item{transcript_id}{Character vector of length 1. Tag in \code{attribute}
field corresponding to transcript IDs. This argument must be supplied and
cannot be \code{NA} or \code{NULL}. Will throw error if tag indicated in this
argument does not exist.}

\item{gene_id}{Character vector of length 1. Tag in \code{attribute}
field corresponding to gene IDs. This argument must be supplied and
cannot be \code{NA} or \code{NULL}. Note that this is different from gene
symbols, which do not have to be unique. This can be Ensembl or Entrez IDs.
However, if the gene symbols are in fact unique for each gene, you may
supply the tag for human readable gene symbols to this argument. Will throw
error if tag indicated in this argument does not exist. This is typically
"gene_id" for annotations from Ensembl and "gene" for refseq.}

\item{gene_name}{Character vector of length 1. Tag in \code{attribute}
field corresponding to gene symbols. This argument can be \code{NA} or
\code{NULL} if you are fine with non-human readable gene IDs and do not wish
to extract human readable gene symbols.}

\item{transcript_version}{Character vector of length 1. Tag in \code{attribute}
field corresponding to \emph{transcript} version number. If your GTF file does not
include transcript version numbers, or if you do not wish to include the
version number, then use \code{NULL} for this argument. To decide whether to
include transcript version number, check whether version numbers are included
in the \code{transcripts.txt} in the \code{kallisto} output directory. If that file
includes version numbers, then trannscript version numbers must be included
here as well. If that file does not include version numbers, then transcript
version numbers must not be included here.}

\item{gene_version}{Character vector of length 1. Tag in \code{attribute}
field corresponding to \emph{gene} version number. If your GTF file does not
include gene version numbers, or if you do not wish to include the
version number, then use \code{NULL} for this argument. Unlike transcript
version number, it's up to you whether to include gene version number.}

\item{version_sep}{Character to separate bewteen the main ID and the version
number. Defaults to ".", as in Ensembl.}

\item{transcript_biotype_col}{Character vector of length 1. Tag in
\code{attribute} field corresponding to \emph{transcript} biotype.}

\item{gene_biotype_col}{Character vector of length 1. Tag in \code{attribute}
field corresponding to \emph{gene} biotype.}

\item{transcript_biotype_use}{Character, can be "all" or
a vector of \emph{transcript} biotypes to be used. Transcript biotypes aren't
entirely the same as gene biotypes. For instance, in Ensembl annotation,
\code{retained_intron} is a transcript biotype, but not a gene biotype. If
"cellranger", then a warning will be given. See \code{data("ensembl_tx_biotypes")}
for all available transcript biotypes from Ensembl.}

\item{gene_biotype_use}{Character, can be "all", "cellranger", or
a vector of \emph{gene} biotypes to be used. If "cellranger", then the biotypes
used by Cell Ranger's reference are used. See \code{data("cellranger_biotypes")}
for gene biotypes the Cell Ranger reference uses. See
\code{data("ensembl_gene_biotypes")} for all available gene biotypes from Ensembl.
Note that gene biotypes and transcript biotypes are not always the same.}

\item{chrs_only}{Logical, whether to include chromosomes only, for GTF and
GFF files can contain annotations for scaffolds, which are not incorporated
into chromosomes. This will also exclude haplotypes. Defaults to \code{TRUE}.
Only applicable to species found in \code{genomeStyles()}.}

\item{compress_fa}{Logical, whether to compress the output fasta file. If
\code{TRUE}, then the fasta file will be gzipped.}

\item{save_filtered_gtf}{Logical. If filtering type, biotypes, and/or
chromosomes, whether to save the filtered \code{GRanges} as a GTF file.}

\item{overwrite}{Logical, whether to overwrite if files with names of outputs
written to disk already exist.}
}
\value{
A data frame at least 2 columns: \code{gene} for gene ID,
\code{transcript} for transcript ID, and optionally, \code{gene_name} for
gene names.
}
\description{
Internal use, for GRanges from GTF files
}
